package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.LogDetailReq;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.entity.LogDetail;
import com.junmp.jyzb.entity.OrderMain;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.jyzb.service.LogDetailService;
import com.junmp.jyzb.mapper.LogDetailMapper;
import com.junmp.jyzb.service.OrderMainService;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_detail】的数据库操作Service实现
* @createDate 2023-10-13 08:29:42
*/
@Service
public class LogDetailServiceImpl extends ServiceImpl<LogDetailMapper, LogDetail>
    implements LogDetailService{

    @Resource
    private LogDetailService logDetailService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private LogDetailMapper logDetailMapper;

    @Resource
    private OrderMainService orderMainService;

    //根据logSumId查询详情
    @Override
    public List<LogDetailDto> GetDetailByLogSumId(LogDetailReq req) {

        List<LogDetailDto> list = logDetailMapper.GetDetailByLogSumId(req.getSummaryId());
        return list;
    }

    //根据单据查询出入库记录
    @Override
    public List<LogDetailDto> ShowInOutRecordsByOrder(LogSummaryReq req) {
        List<LogDetailDto> list = logDetailMapper.ShowInOutRecordsByOrder(req.getOrderMainId());
        return list;
    }


    //获取装备的出入库信息（根据装备id或者epc获取该装备的出入库记录）
    @Override
    public PageResult<LogDetail> getInOutRecords(InventoryReq req) {
        //通过装备id获取出入库记录(判断id是否存在)
        inventoryService.InventoryExist(req.getId());
        LambdaQueryWrapper<LogDetail> eq = new LambdaQueryWrapper<LogDetail>()
                .eq(ObjectUtil.isNotNull(req.getEpc()),LogDetail::getEpc,req.getEpc());
        Page<LogDetail> page = logDetailService.page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }
}




