package com.junmp.jyzb.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.api.bean.dto.BussinessInventoryDto;
import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.dto.EquipmentListDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.query.BussinessInventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.req.UpdateInventoryReq;
import com.junmp.jyzb.api.bean.req.UpdateStocktakeReq;
import com.junmp.jyzb.api.bean.req.UploadInventoryReq;
import com.junmp.jyzb.api.exception.enums.EquipmentExceptionEnum;
import com.junmp.jyzb.api.exception.enums.InventoryExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.BussinessInventoryDetailMapper;
import com.junmp.jyzb.mapper.BussinessInventoryMapper;
import com.junmp.jyzb.mapper.CabinetBoxPoliceMapper;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.RabbitMQSendMsg;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDict;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import com.junmp.v2.dict.service.SysDictService;
import com.junmp.v2.sys.api.OrganizationServiceApi;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.beans.Transient;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BussinessInventoryServiceImpl extends ServiceImpl<BussinessInventoryMapper, BussinessInventory>
        implements BussinessInventoryService {

    @Resource
    private IFlowInstanceService FlowInstanceService;
    @Resource
    private InventorySummaryService inventorySummaryService;
    @Resource
    private SysDictItemService sysDictItemService;
    @Resource
    private SysDictService sysDictService;
    @Resource
    private BussinessInventoryDetailService bussinessInventoryDetailService;
    @Resource
    private WarehouseService warehouseService;
    @Resource
    private PubOrgService orgService;
    @Resource
    private WarehouseInventoryService warehouseInventoryService;
    @Resource
    private OrderNumService orderNumService;
    @Autowired
    private RabbitMQSendMsg MQ;

    @Transactional(rollbackFor = Exception.class)
    public String AddInvOrder(UpdateInventoryReq req) {
        if (StringUtils.isNotBlank(req.getId()))
        {
            BussinessInventory BI=this.getById(req.getId());
            Warehouse warehouse= warehouseService.getById(req.getWarehouseId());
            PubOrg pubOrg=orgService.getById(req.getOrgId());
            BeanPlusUtil.copyProperties(req,BI);

            BI.setWarehouseName(warehouse.getName());
            if (StringUtils.isNotBlank(pubOrg.getDName()) )
            {
                BI.setOrgName(pubOrg.getOrgName());
            }
            else
            {
                BI.setOrgName(pubOrg.getDName());
            }
            BI.setUpdateTime(DateTimeUtil.getCurrentDateTime());
            //执行工作流
            if (req.getExamineState().equals("working"))
            {
                StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
                startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
                startProcessInstanceDTO.setOrderId(BI.getId());
                startProcessInstanceDTO.setOrderType("stocktakeOrder");
                String ProcessInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);
                BI.setProcessId(Long.valueOf(ProcessInstanceId));

                String assigns= FlowInstanceService.GetNextAssign(ProcessInstanceId);//这里需要手动更新审核人信息
                BI.setCurrentAssign(assigns);
                updateById(BI);

            }
            this.save(BI);
            return BI.getId();
        }
        else
        {  BussinessInventory BI = new BussinessInventory();
            Warehouse warehouse= warehouseService.getById(req.getWarehouseId());
            PubOrg pubOrg=orgService.getById(req.getOrgId());
            BeanPlusUtil.copyProperties(req,BI);
            BI.setWarehouseName(warehouse.getName());
            //设置单号
            if (ObjectUtil.isNull(pubOrg.getDName()) )
            {
                BI.setOrgName(pubOrg.getOrgName());
            }
            else
            {
                BI.setOrgName(pubOrg.getDName());
            }
            BI.setYear(LocalDate.now().getYear());
            BI.setMonth(Integer.valueOf(LocalDate.now().getMonthValue()));

            OrderNum orderNum = setOrderCode("bussinessInventory",req.getOrgId());
            String codeValue=String.format("%04d",orderNum.getNum());
            BI.setOrderNum(orderNum.getBussinessType()+orderNum.getYear()+
                    String.format("%02d", LocalDateTime.now().getMonth().getValue())+
                    String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);

            BI.setCreateTime(DateTimeUtil.getCurrentDateTime());
            BI.setUpdateTime(DateTimeUtil.getCurrentDateTime());
            BI.setInventoryState("waitting");
            //执行工作流
            if (req.getExamineState().equals("working"))
            {
                StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
                startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
                startProcessInstanceDTO.setOrderId(BI.getId());
                startProcessInstanceDTO.setOrderType("stocktakeOrder");
//            startProcessInstanceDTO.setUserId(req.getUserId());
                String ProcessInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);
                BI.setProcessId(Long.valueOf(ProcessInstanceId));

                String assigns= FlowInstanceService.GetNextAssign(ProcessInstanceId);//这里需要手动更新审核人信息
                BI.setCurrentAssign(assigns);
                updateById(BI);

            }
            this.save(BI);
            return BI.getId();}

    }

    @Override
    public BussinessInventoryDto Check(BussinessInventoryReq req) {
        String Id=req.getOrderId();
        if (StringUtils.isNotBlank(Id))//如果传了订单号，则全部通过订单号查询
        {
           BussinessInventory inventory= this.getById(Id);
            String type=inventory.getInventoryType().toString();
            String warehouseId=inventory.getWarehouseId();
            InventorySumReq sumreq=new InventorySumReq();
            sumreq.setLocationType("0");
            sumreq.setLocationId(warehouseId);
            BussinessInventoryDto BIDto=new BussinessInventoryDto();

                if (type.equals("1"))//按装备类型盘点
                {
                    List<String> typeIds = Arrays.asList(inventory.getRules().split(","));
                    sumreq.setTypeIds(typeIds);
                } else if (type.equals("2"))//按装备号型盘点
                {
                    List<String> sizeIds = Arrays.asList(inventory.getRules().split(","));
                    sumreq.setSizeIds(sizeIds);
                }

            List<EquipmentListDto> eqList=new ArrayList<>();
            Integer totalNumber=0;
            List<InventorySummary> SumResult = inventorySummaryService.getEquipmentInfoList(sumreq);
            for (InventorySummary summary : SumResult) {
                EquipmentListDto eq=new EquipmentListDto();
                BeanPlusUtil.copyProperties(summary,eq);
                eq.setPlanNum(String.valueOf(summary.getStockNumber()));
                totalNumber+=summary.getStockNumber();
                eqList.add(eq);
            }
            BIDto.setTotalNum(String.valueOf(totalNumber));
            BIDto.setEquipmentList(eqList);
            return  BIDto;
        }
        String type=req.getType();
        String warehouseId=req.getWarehouseId();
        InventorySumReq sumreq=new InventorySumReq();
        sumreq.setLocationType("0");
        sumreq.setLocationId(warehouseId);

        BussinessInventoryDto BIDto=new BussinessInventoryDto();
        if (ObjectUtil.isEmpty(type) || ObjectUtil.isNull(type)) {
        }
        else {
            if (type.equals("1"))//按装备类型盘点
            {
                List<String> typeIds = Arrays.asList(req.getTypeList().split(","));
                sumreq.setTypeIds(typeIds);
            } else if (type.equals("2"))//按装备号型盘点
            {
                List<String> sizeIds = Arrays.asList(req.getTypeList().split(","));
                sumreq.setSizeIds(sizeIds);
            }
        }
            List<EquipmentListDto> eqList=new ArrayList<>();
            Integer totalNumber=0;
            List<InventorySummary> SumResult = inventorySummaryService.getEquipmentInfoList(sumreq);
            for (InventorySummary summary : SumResult) {
                EquipmentListDto eq=new EquipmentListDto();
                BeanPlusUtil.copyProperties(summary,eq);
                eq.setPlanNum(String.valueOf(summary.getStockNumber()));
                totalNumber+=summary.getStockNumber();
                eqList.add(eq);
            }
            BIDto.setTotalNum(String.valueOf(totalNumber));
            BIDto.setEquipmentList(eqList);
            return  BIDto;

    }

    //开始盘点
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean Start(BussinessInventoryReq req) {
        String orderId=req.getOrderId();
        BussinessInventory bi= this.getById(orderId);

        if (bi!=null)
        {
            bi.setInventoryState("running");
            this.save(bi);
        }
        else
        {
            throw new ServiceException(InventoryExceptionEnum.ORDER_NOT_EXIST);

        }
        return true;
    }
    @Override
    public BussinessInventoryDto GetDetailById(BussinessInventoryReq req) {
        BussinessInventory inventory= this.getById(req.getOrderId());
        List<BussinessDetail> details = bussinessInventoryDetailService.list(
                    new LambdaQueryWrapper<BussinessDetail>().eq(BussinessDetail::getInventoryId, req.getOrderId())
            );

    List<EquipmentListDto> eqDtoList=new ArrayList<>();
        BussinessInventoryDto BIDTO=new BussinessInventoryDto();
        BeanPlusUtil.copyProperties(inventory,BIDTO);
        for (BussinessDetail detail : details) {
            EquipmentListDto eqDto = new EquipmentListDto();

            BeanPlusUtil.copyProperties(detail, eqDto);
            eqDtoList.add(eqDto);
        }
        BIDTO.setState(inventory.getResult());
        BIDTO.setEquipmentList(eqDtoList);
        return BIDTO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean UploadStock(UploadInventoryReq req) {
        //更新之前先把库存表的epc备份
       BussinessInventory BI=  this.getById(req.getOrderId());
       String type= BI.getInventoryType().toString();
        InventorySumReq sumreq=new InventorySumReq();
        String epcList="";
        List<WarehouseInventory> details=new ArrayList<>();
        if (type.equals("0"))
        {

             details = warehouseInventoryService.list(
                    new LambdaQueryWrapper<WarehouseInventory>().eq(WarehouseInventory::getLocationId, BI.getWarehouseId())
            );


        } else if (type.equals("1"))//按装备类型盘点
        {
            List<String> typeIds = Arrays.asList(BI.getRules().split(","));
            details = warehouseInventoryService.list(
                    new LambdaQueryWrapper<WarehouseInventory>().eq(WarehouseInventory::getLocationId, BI.getWarehouseId())
                    .and(qw -> typeIds.forEach(typeId -> qw.or().eq(WarehouseInventory::getTypeId, typeId)))
            );
        }
        else if (type.equals("2"))//按号型盘点
        {
            List<String> sizeIds = Arrays.asList(BI.getRules().split(","));
            details = warehouseInventoryService.list(
                    new LambdaQueryWrapper<WarehouseInventory>().eq(WarehouseInventory::getLocationId, BI.getWarehouseId())
                            .and(qw -> sizeIds.forEach(size -> qw.or().eq(WarehouseInventory::getSizeId, size)))
            );
        }
        for (WarehouseInventory detail : details) {
            String epc = detail.getEpc();
            if (epc != null && !epc.isEmpty()) {
                if (!epcList.isEmpty()) {
                    epcList += ",";
                }
                epcList += epc;
            }
        }
        // 去除最后一个逗号
        if (epcList.endsWith(",")) {
            epcList = epcList.substring(0, epcList.length() - 1);
        }
        BI.setEpcBack(epcList);
        //将上报的数据传入数据库存储
        BeanPlusUtil.copyProperties(req,BI);
        List<BussinessDetail> Bussinessdetails=new ArrayList<>();
        for (EquipmentListDto detail : req.getEquipmentList()) {
            BussinessDetail eqDto = new BussinessDetail();
            BeanPlusUtil.copyProperties(detail, eqDto);
            eqDto.setInventoryId(Long.valueOf(req.getOrderId()));
            Bussinessdetails.add(eqDto);
        }
        BI.setResult(req.getState());
        BI.setInventoryState("finished");
        this.updateById(BI);
        bussinessInventoryDetailService.saveBatch(Bussinessdetails);

        return true;
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean UseOrFinished(UploadInventoryReq req) {
        //更新之前先把库存表的epc备份
        BussinessInventory BI=  this.getById(req.getOrderId());
        List<BussinessDetail> details;
        List<WarehouseInventory> DeleteList;
        List<WarehouseInventory> UpdateList;
        List<BussinessDetail> BusinessDetail = bussinessInventoryDetailService.list(
                new LambdaQueryWrapper<BussinessDetail>().eq(BussinessDetail::getInventoryId, req.getOrderId())
        );
        InventorySumReq sumreq=new InventorySumReq();
        sumreq.setLocationType("0");
        sumreq.setLocationId(BI.getWarehouseId());
        if (BI.getInventoryType().equals("1"))//按装备类型盘点
        {
            List<String> typeIds = Arrays.asList(BI.getRules().split(","));
            sumreq.setTypeIds(typeIds);
        } else if (BI.getInventoryType().equals("2"))//按装备号型盘点
        {
            List<String> sizeIds = Arrays.asList(BI.getRules().split(","));
            sumreq.setSizeIds(sizeIds);
        }
        List<InventorySummary> SumResult = inventorySummaryService.getEquipmentInfoList(sumreq);
        for (InventorySummary summary : SumResult) {
            for (BussinessDetail businessDetail : BusinessDetail) {
                if (summary.getTypeId().equals(businessDetail.getTypeId()) && summary.getSizeId().equals(businessDetail.getSizeId())) {
                    summary.setStockNumber(businessDetail.getFixNumber());
                    summary.setOutboundNumber(0);
                    summary.setNumber(businessDetail.getFixNumber());
                    if (businessDetail.getState().equals(1))//盈余状态需要增加金额和数量
                    {
                        summary.setPrice( summary.getPrice().add(businessDetail.getFixPrice()));
                        businessDetail.setStockPrice(summary.getStockNumberPrice());

                    }
                    else if (businessDetail.getState().equals(2))//亏损状态需要减少金额和数量
                    {
                        BigDecimal fixPriceNew=summary.getPrice().subtract(businessDetail.getFixPrice());
                        int i = fixPriceNew.compareTo(BigDecimal.ZERO);
                        if (i == -1) {
                            summary.setPrice(BigDecimal.ZERO);
                        } else if (i == 1||i == 0) {
                            summary.setPrice( fixPriceNew);
                        }

                    }


                }
            }


        }

//        if (req.getState().equals("0"))//确认结果
//        {
            List<String> DeleteInventorys = Arrays.asList(BI.getEpcBack().split(","));
            DeleteList = warehouseInventoryService.list(//找出所有
                    new LambdaQueryWrapper<WarehouseInventory>()
                            .and(qw -> DeleteInventorys.forEach(epc -> qw.or().eq(WarehouseInventory::getEpc, epc)))
            );

            List<String> UpdateInventorys = Arrays.asList(BI.getEpc_update().split(","));
            UpdateList = warehouseInventoryService.list(//找出所有
                    new LambdaQueryWrapper<WarehouseInventory>()
                            .and(qw -> UpdateInventorys.forEach(epc -> qw.or().eq(WarehouseInventory::getEpc, epc)))
            );
            warehouseInventoryService.removeBatchByIds(DeleteList);
            warehouseInventoryService.saveBatch(UpdateList);
            BI.setInventoryState("close");
            BI.setUpdateTime(DateTimeUtil.getCurrentDateTime());
            this.updateById(BI);
            inventorySummaryService.updateBatchById(SumResult);
//        }
//        else if (req.getState().equals("1"))//回滚结果
//        {
//            List<String> DeleteInventorys = Arrays.asList(BI.getEpcBack().split(","));
//             UpdateList= warehouseInventoryService.list(//找出所有
//                    new LambdaQueryWrapper<WarehouseInventory>()
//                            .and(qw -> DeleteInventorys.forEach(epc -> qw.or().eq(WarehouseInventory::getEpc, epc)))
//            );
//            List<String> UpdateInventorys = Arrays.asList(BI.getEpc_update().split(","));
//            DeleteList = warehouseInventoryService.list(//找出所有
//                    new LambdaQueryWrapper<WarehouseInventory>()
//                            .and(qw -> UpdateInventorys.forEach(epc -> qw.or().eq(WarehouseInventory::getEpc, epc)))
//            );
//            warehouseInventoryService.removeBatchByIds(DeleteList);
//            warehouseInventoryService.saveBatch(UpdateList);
//            BI.setInventoryState("close");
//            BI.setUpdateTime(DateTimeUtil.getCurrentDateTime());
//            this.updateById(BI);
//        }


        return true;
    }

    @Override
    public PageResult<BussinessInventory> GetPage(BussinessInventoryReq req) {
        //排序字段处理，将驼峰改成和数据库同步的字段名(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) &&!req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<BussinessInventory> wrapper = createWrapper(req);


        // 使用 PageHelper 开始分页
//        Page<BussinessInventory> page = PageFactory.getDefaultPage(Long.parseLong(req.getPageNo()),Long.parseLong(req.getPageSize()));
        Page<BussinessInventory> page = this.page(PageFactory.getDefaultPage(), wrapper);

      return   PageResultFactory.createPageResult(page);

    }



    /**
     * 设置单据单号
     * 通用方法，根据组织机构id以及业务单据类型来进行设置
     * @param
     */
    public OrderNum setOrderCode(String bussinessType,Long orgId){
        //设置采购单号，需要先判断该组织机构的采购单号是否存在，如果存在则将数量进行增加，如果不存在则新增一条对应的数据
        OrderNum orderNum = new OrderNum();
        orderNum.setYear(LocalDateTime.now().getYear());
        orderNum.setBussinessType(bussinessType);
        orderNum.setOrgId(orgId);
        //将业务类型转为中文简写
        Long sysDictId = sysDictService.getOne(new LambdaQueryWrapper<SysDict>()
                .eq(SysDict::getDictCode, "busstype_chinese")).getDictId();

        String itemValue = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, bussinessType)
                .eq(SysDictItem::getDictId,sysDictId)).getItemValue();
        orderNum.setBussinessType(itemValue);
        OrderNum one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                .eq(OrderNum::getOrgId, orderNum.getOrgId())
                .eq(OrderNum::getBussinessType, orderNum.getBussinessType())
                .eq(OrderNum::getYear, orderNum.getYear()));
        //设置num的数量
        if (ObjectUtil.isNull(one)){
            orderNum.setNum(1);
            orderNumService.save(orderNum);
            return orderNum;
        }else {
            one.setNum(one.getNum()+1);
            orderNumService.updateById(one);
            return one;
        }
    }

    private LambdaQueryWrapper<BussinessInventory> createWrapper(BussinessInventoryReq req) {
        LambdaQueryWrapper<BussinessInventory> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        wrapper.eq(BussinessInventory::getOrgId, req.getOrgId());
        wrapper.eq(StringUtils.isNotBlank(req.getWarehouseId()), BussinessInventory::getWarehouseId, req.getWarehouseId());
        wrapper.eq(StringUtils.isNotBlank(req.getInventoryState()), BussinessInventory::getInventoryState, req.getInventoryState());
        wrapper.eq(StringUtils.isNotBlank(req.getExamineState()), BussinessInventory::getExamineState, req.getExamineState());
        wrapper.eq(StringUtils.isNotBlank(req.getInventoryType()), BussinessInventory::getInventoryType, req.getInventoryType());
        return wrapper;
    }

}