package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.SupplierDto;
import com.junmp.jyzb.api.bean.query.QuerySupplierReq;
import com.junmp.jyzb.api.bean.req.UpdateSupplierReq;
import com.junmp.jyzb.api.exception.enums.SupplierExceptionEnum;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.SupplierMapper;

import java.util.*;

@Service
public class SupplierServiceImpl extends ServiceImpl<SupplierMapper, Supplier> implements SupplierService {

    @Resource
    private SupplierMapper supplierMapper;


    @Override
    public boolean AddSupplier(UpdateSupplierReq req) {
        Supplier supplier = new Supplier();
        BeanPlusUtil.copyProperties(req, supplier);
        return this.save(supplier);
    }



    @Override
    public boolean DeleteSupplier(UpdateSupplierReq req) {
        this.removeById(req.getId());
        return true;
    }

    @Override
    public boolean UpdateSupplier(UpdateSupplierReq req) {
        Supplier supplier = this.QuerySupplier(req);
        BeanPlusUtil.copyProperties(req, supplier);
        return this.updateById(supplier);
    }

    private Supplier QuerySupplier(UpdateSupplierReq req) {
        Supplier app = this.getById(req.getId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(SupplierExceptionEnum.SUPPLIER_NOT_EXIST);
        }
        return app;
    }


    public List<String>  CheckSupplierList(List<String> req){
        LambdaQueryWrapper<Supplier> wp = new LambdaQueryWrapper<>();
        wp.in(ObjectUtil.isNotEmpty(req), Supplier::getId, req);
        List<Supplier> st = list(wp);

        List<String> nonexistentSuppliers = new ArrayList<>();
        for (String supplierId : req) {
            boolean found = false;
            for (Supplier supplier : st) {
                if (supplier.getId().equals(supplierId)) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                nonexistentSuppliers.add(supplierId);
            }
        }

        return nonexistentSuppliers;

    }



    @Override
    public List<SupplierDto> ShowSupplier(QuerySupplierReq req) {

        LambdaQueryWrapper<Supplier> wrapper = createWrapper(req);
        List<SupplierDto> dto=new ArrayList<>();
        this.list(wrapper).forEach(p->
        {
            SupplierDto sd=new SupplierDto();
            BeanPlusUtil.copyProperties(p, sd);
            dto.add(sd);
        });
        return dto;
    }

    @Override
    public Boolean ChangeSupplierState(UpdateSupplierReq req) {
        Supplier supplier = this.QuerySupplier(req);
        BeanPlusUtil.copyProperties(req, supplier);
        return this.updateById(supplier);
    }

    private LambdaQueryWrapper<Supplier> createWrapper(QuerySupplierReq req) {
        LambdaQueryWrapper<Supplier> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据供应商短码查询查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getCode()), Supplier::getCode, req.getCode());
        //供应商名称模糊查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getName()), Supplier::getName, req.getName());
        //根据创建时间降序
        wrapper.orderByDesc(Supplier::getCreateTime);
        return wrapper;
    }
}
