package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.ShelfReq;
import com.junmp.jyzb.api.exception.enums.ShelfExceptionEnum;
import com.junmp.jyzb.entity.Shelf;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.ShelfMapper;
import com.junmp.jyzb.service.ShelfService;

import java.util.List;

@Service
public class ShelfServiceImpl extends ServiceImpl<ShelfMapper, Shelf> implements ShelfService {

    @Resource
    private ShelfMapper shelfMapper;

    @Override
    public boolean addShelf(ShelfReq req) {
        Shelf shelf = new Shelf();
        BeanPlusUtil.copyProperties(req,shelf);
        return this.save(shelf);
    }

    @Override
    public boolean updateShelf(ShelfReq req) {
        Shelf shelf = this.queryShelf(req);
        BeanPlusUtil.copyProperties(req, shelf);
        return this.updateById(shelf);
    }

    @Override
    public boolean deleteShelf(ShelfReq req) {
        Shelf shelf = queryShelf(req);
        this.removeById(req.getShelfId());
        return true;
    }

    @Override
    public List<Shelf> getShelfList(ShelfReq req) {
        LambdaQueryWrapper<Shelf> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    private Shelf queryShelf(ShelfReq req) {
        Shelf app = this.getById(req.getShelfId());

        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ShelfExceptionEnum.SHELF_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<Shelf> createWrapper(ShelfReq req) {
        LambdaQueryWrapper<Shelf> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据货架id查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getShelfId()), Shelf::getShelfId, req.getShelfId());
        //根据货架名称、货架编号模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getShelfName()), Shelf::getCode, req.getShelfName());

        wrapper.orderByDesc(Shelf::getCreateTime);
        return wrapper;
    }
}
