package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.entity.OrderMain;
import com.junmp.jyzb.mapper.OrderMainMapper;
import com.junmp.jyzb.service.OrderService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class OrderServiceImpl implements OrderService {

    @Resource
    private OrderMainMapper orderMapper;

    @Override
    public ResponseResult addOrder(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orderType"), "orderType不能为空");
            checkNotBlank(msg.get("processId"), "processId不能为空");
            checkNotBlank(msg.get("bussinessType"), "bussinessType不能为空");
            checkNotBlank(msg.get("orderCode"), "orderCode不能为空");
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("inventoryQuantity"), "inventoryQuantity不能为空");
            checkNotBlank(msg.get("manualState"), "manualState不能为空");
            checkNotBlank(msg.get("orderState"), "orderState不能为空");
            checkNotBlank(msg.get("attachmentLocation"), "attachmentLocation不能为空");
            checkNotBlank(msg.get("invList"), "invList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        OrderMain order = new OrderMain();

        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        order.setCreateTime(currentDate);
        order.setUpdateTime(currentDate);

        order.setOrderType((String) msg.get("orderType"));
        order.setProcessId((String) msg.get("processId"));
        order.setBussinessType((String) msg.get("bussinessType"));
        order.setOrderCode((String) msg.get("orderCode"));
        order.setInventoryQuantity((Integer) msg.get("inventoryQuantity"));
        order.setManualState((Integer) msg.get("manualState"));
        order.setOrderState((Integer) msg.get("orderState"));
        order.setAttachmentLocation((String) msg.get("attachmentLocation"));
        order.setInvList((String) msg.get("invList"));

        Long id = orderMapper.addOrder(order);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,id);
    }

    @Override
    public ResponseResult showOrder(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String orgId = msg.get("orgId").toString();
        List<Map<String,Object>> allMsg = orderMapper.showOrder(orgId);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,allMsg);
    }

    @Override
    public ResponseResult updateOrder(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("orderType"), "orderType不能为空");
            checkNotBlank(msg.get("processId"), "processId不能为空");
            checkNotBlank(msg.get("bussinessType"), "bussinessType不能为空");
            checkNotBlank(msg.get("orderCode"), "orderCode不能为空");
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("inventoryQuantity"), "inventoryQuantity不能为空");
            checkNotBlank(msg.get("manualState"), "manualState不能为空");
            checkNotBlank(msg.get("orderState"), "orderState不能为空");
            checkNotBlank(msg.get("attachmentLocation"), "attachmentLocation不能为空");
            checkNotBlank(msg.get("invList"), "invList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        OrderMain order = new OrderMain();

        //生成当前时间
        order.setId((Long) msg.get("id"));

        Date currentDate = DateTimeUtil.getCurrentDateTime();
        order.setUpdateTime(currentDate);

        order.setOrderType((String) msg.get("orderType"));
        order.setProcessId((String) msg.get("processId"));
        order.setBussinessType((String) msg.get("bussinessType"));
        order.setOrderCode((String) msg.get("orderCode"));
        order.setInventoryQuantity((Integer) msg.get("inventoryQuantity"));
        order.setManualState((Integer) msg.get("manualState"));
        order.setOrderState((Integer) msg.get("orderState"));
        order.setAttachmentLocation((String) msg.get("attachmentLocation"));
        order.setInvList((String) msg.get("invList"));

        orderMapper.updateOrder(order);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult getOrderDetail(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String id = msg.get("id").toString();
        Map<String,Object> oneMsg = orderMapper.getOrderDetail(id);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,oneMsg);
    }
}
