package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.api.exception.JYZBAppException;
import com.junmp.jyzb.api.exception.enums.EquipmentTypeExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.SupplierMapper;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.jyzb.service.SupplierTypeService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.data.annotation.Id;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class EquipmentTypeServiceImpl extends ServiceImpl<EquipmentTypeMapper, EquipmentType> implements EquipmentTypeService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;


    @Resource
    private SupplierService supplierService;
    @Resource
    private SupplierTypeService supplierTypeService;
    private static final String REDIS_TYPE = "Type_";


    public List<EquipmentTreeDto> getEquipmentList(QueryEquipmentTypeReq req) {
        String selfCode="00000000-0000-0000-0000-000000000000";

        List<EquipmentTreeDto> equipmentTypeDTOList = new ArrayList<>();
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        String setNewCode="";
        if (ObjectUtil.isNotEmpty(req.getCode())) {
            {
                setNewCode=req.getCode().replaceAll("0+$", "");
            }
        }
        wrapper.likeRight(ObjectUtil.isNotEmpty(req.getCode()), EquipmentType::getCode, setNewCode);
        List<EquipmentType> equipmentList = this.list(wrapper);

        // 创建一个 Map 来存储 Equipment ID 和对应的 DTO 对象
        Map<String, EquipmentTreeDto> equipmentDtoMap = new HashMap<>();
        // 创建一个 Map 来存储父类的 parentid 和对应的父类节点
        Map<String, EquipmentTreeDto> parentDtoMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(req.getCode())&&!req.getCode().equals("00000000-0000-0000-0000-000000000000"))
        {   LambdaQueryWrapper<EquipmentType> wrapper2 = new LambdaQueryWrapper<>();
            if (ObjectUtil.isNotEmpty(req.getCode()))
            {
                selfCode=req.getCode();
            }
            wrapper2.eq(ObjectUtil.isNotEmpty(req.getCode()), EquipmentType::getCode, selfCode);
            String id= this.getOne(wrapper2).getId();
            selfCode=id;
            EquipmentType et=this.getById(id);
            EquipmentTreeDto equipmentTypeDTO = new EquipmentTreeDto();
            equipmentTypeDTO.setName(et.getName());
            equipmentTypeDTO.setCode(et.getCode());
            equipmentTypeDTO.setType(et.getType());
            equipmentDtoMap.put(et.getId(),equipmentTypeDTO);
        }

        // 第一轮遍历：创建 EquipmentTreeDto 对象并将其加入到 Map 中
        for (EquipmentType equipment : equipmentList) {
            EquipmentTreeDto equipmentTypeDTO = new EquipmentTreeDto();
            equipmentTypeDTO.setName(equipment.getName());
            equipmentTypeDTO.setCode(equipment.getCode());
            equipmentTypeDTO.setType(equipment.getType());
            equipmentDtoMap.put(equipment.getId(), equipmentTypeDTO);

            // 如果 parentid 是传进来的值，则将其作为顶级节点添加到 equipmentTypeDTOList 中
            if (equipment.getId().equals(selfCode)) {
                equipmentTypeDTOList.add(equipmentTypeDTO);
            }
        }

        // 第二轮遍历：将子节点连接到父节点
        boolean isStartAddingChildren = false;
        for (EquipmentType equipment : equipmentList) {
            String parentId = equipment.getParentId();
            EquipmentTreeDto equipmentTypeDTO = equipmentDtoMap.get(equipment.getId());

            // 如果找到传入的ID对应的节点，则开始添加子节点
            if (equipment.getId().equals(selfCode)) {
                isStartAddingChildren = true;
            }

            // 如果 isStartAddingChildren 为 true，并且 parentDtoMap 中有对应的父类节点，则将节点连接到父节点
            if (isStartAddingChildren && parentDtoMap.containsKey(parentId)) {
                EquipmentTreeDto parentDto = parentDtoMap.get(parentId);
                parentDto.addChild(equipmentTypeDTO);
            }

            // 将当前节点添加到 parentDtoMap 中，以便后续节点连接
            parentDtoMap.put(equipment.getId(), equipmentTypeDTO);
        }

        return equipmentTypeDTOList;
    }


    @Transactional
    @Override
    public Boolean addEquipment(UpdateEquipmentTypeReq req) {

        EquipmentType type = new EquipmentType();


        List<String> chekResult = supplierService.CheckSupplierList(req.getSupplierList());
        if (chekResult.size() == 0) {

            //先增加code码
            BeanPlusUtil.copyProperties(req, type);
            EquipmentType parentType = this.getById(req.getParentId());
            int newcode = parentType.getMaxCode() + 1;
            type.setId(String.valueOf(newcode));
            parentType.setMaxCode(newcode);
            parentType.setCode(String.valueOf(newcode));
            List<SupplierType> supplierType = new ArrayList<>();
            req.getSupplierList().forEach(supply -> {
                SupplierType st = new SupplierType();
                st.setId(String.valueOf(UUID.randomUUID()));
                st.setState(0);
                st.setSupplierId(supply);
                st.setTypeId(String.valueOf(newcode));
                supplierType.add(st);
                    }
            );
            supplierTypeService.saveBatch(supplierType);
            this.updateById(parentType);
            return this.save(type);
        } else {
            String msg="以下供应商不存在：" +String.join(",", chekResult);
            throw new JYZBAppException(EquipmentTypeExceptionEnum.SUPPLIER_NOT_EXIST, msg);
        }
    }



    @Override
    public Boolean deleteEquipment(UpdateEquipmentTypeReq req) {
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()), EquipmentType::getParentId, req.getParentId());
        List<EquipmentType> eqList = list(wrapper);
        if (eqList.size() > 0) {
            throw new ServiceException(EquipmentTypeExceptionEnum.EQUIPMENT_CHILDREN_EXIST);
        } else {
            this.removeById(req.getId());
        }

        return true;
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateEquipment(UpdateEquipmentTypeReq req) {
        EquipmentType type = this.queryEqType(req);

        List<String> chekResult = supplierService.CheckSupplierList(req.getSupplierList());
        if (chekResult.size() == 0) {
            // 先增加code码
            BeanPlusUtil.copyProperties(req, type);

            // 获取当前type对应的所有关联的供应商
            List<SupplierType> currentSupplierList = supplierTypeService.list(new LambdaQueryWrapper<SupplierType>()
                    .eq(SupplierType::getTypeId, type.getId()));

            // 获取当前type对应的所有关联的供应商ID集合
            Set<String> currentSupplierIds = currentSupplierList.stream()
                    .map(SupplierType::getSupplierId)
                    .collect(Collectors.toSet());

            // 获取传入的supplierList中的所有供应商ID集合
            Set<String> newSupplierIds = new HashSet<>(req.getSupplierList());

            // 需要新增的供应商关联数据
            List<SupplierType> supplierTypeToAdd = new ArrayList<>();
            for (String supplierId : newSupplierIds) {
                if (!currentSupplierIds.contains(supplierId)) {
                    SupplierType st = new SupplierType();
                    st.setId(String.valueOf(UUID.randomUUID()));
                    st.setState(0);
                    st.setSupplierId(supplierId);
                    st.setTypeId(String.valueOf(type.getId()));
                    supplierTypeToAdd.add(st);
                }
            }

            // 需要删除的供应商关联数据
            List<SupplierType> supplierTypeToDelete = new ArrayList<>();
            for (SupplierType currentSupplier : currentSupplierList) {
                if (!newSupplierIds.contains(currentSupplier.getSupplierId())) {
                    supplierTypeToDelete.add(currentSupplier);
                }
            }

            // 保存新增的供应商关联数据
            supplierTypeService.saveBatch(supplierTypeToAdd);

            // 删除需要删除的供应商关联数据
            if (!supplierTypeToDelete.isEmpty()) {
                supplierTypeService.removeByIds(supplierTypeToDelete.stream()
                        .map(SupplierType::getId)
                        .collect(Collectors.toList()));
            }
            // 保存type
            return this.updateById(type);
        } else {
            String msg="以下供应商不存在：" +String.join(",", chekResult);
            throw new JYZBAppException(EquipmentTypeExceptionEnum.SUPPLIER_NOT_EXIST, msg);
        }
    }

    private EquipmentType queryEqType(UpdateEquipmentTypeReq req) {
        EquipmentType type = this.getById(req.getId());

        if (ObjectUtil.isNull(type)) {
            throw new ServiceException(EquipmentTypeExceptionEnum.EQUIPMENT_TYPE_NOT_EXIST);
        }
        return type;
    }


    @Override
    public Boolean changeEquipmentState(UpdateEquipmentTypeReq req) {
        EquipmentType equipment = this.getById(req.getId());
        if (equipment != null) {
            equipment.setState(Integer.valueOf(req.getState()));
        }
        return true;
    }


    @Override
    public EquipmentTypeDto getEquipment(QueryEquipmentTypeReq req) {
        EquipmentTypeDto equipment = new EquipmentTypeDto();
        BeanPlusUtil.copyProperties(this.getById(req.getId()), equipment);
        return equipment;
    }


    @Override
    public ResponseResult setTypeParentIds() {
        //清空parent_ids字段
        equipmentTypeMapper.wipeParentIdsData();
        //更新parent_ids字段
        equipmentTypeMapper.setTypeParentIds();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }


    private LambdaQueryWrapper<EquipmentType> createWrapper(QueryEquipmentTypeReq req) {
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
            wrapper.orderByDesc(EquipmentType::getCreateTime);
            return wrapper;

    }
}


