package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.EquipmentSizeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentSizeReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentSizeMapper;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class EquipmentSizeServiceImpl extends ServiceImpl<EquipmentSizeMapper, EquipmentSize> implements EquipmentSizeService {

    @Resource
    private EquipmentSizeMapper equipmentSizeMapper;


    @Override
    public Boolean addSize(UpdateEquipmentSizeReq req) {
        EquipmentSize size = new EquipmentSize();
        BeanPlusUtil.copyProperties(req, size);
        return this.save(size);
    }

    @Override
    public EquipmentSize getOneSize(QueryEquipmentSizeReq req) {
        return this.getById(req);
    }

    @Override
    public Boolean deleteSize(UpdateEquipmentSizeReq req) {
        return this.removeById(req.getId());

    }

    @Override
    public Boolean updateSize(UpdateEquipmentSizeReq req) {
        EquipmentSize size = this.querySize(req);
        BeanPlusUtil.copyProperties(req, size);
        return this.updateById(size);
    }

    @Override
    public Boolean changeSizeState(UpdateEquipmentSizeReq req) {
        EquipmentSize size = this.querySize(req);
        return this.updateById(size);
    }

    @Override
    public List<EquipmentSizeDto> getAllSize(QueryEquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = createWrapper(req);
        List<EquipmentSize> es = this.list(wrapper);


        List<EquipmentSizeDto> dtoList = new ArrayList<>();

        // 将 EquipmentSize 对象转换为 EquipmentSizeDto 对象并添加到 dtoList 中
        for (EquipmentSize equipmentSize : es) {
            EquipmentSizeDto dto = new EquipmentSizeDto();
            BeanPlusUtil.copyProperties(equipmentSize, dto);
            dtoList.add(dto);
        }
        return dtoList;
    }

    private EquipmentSize querySize(UpdateEquipmentSizeReq req) {
        EquipmentSize app = this.getById(req.getId());

        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.SIZE_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<EquipmentSize> createWrapper(QueryEquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeId()), EquipmentSize::getTypeId, req.getTypeId());
        //根据名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), EquipmentSize::getName, req.getName());

        wrapper.orderByDesc(EquipmentSize::getCreateTime);
        return wrapper;
    }
}