package com.junmp.jyzb.service.impl;


import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.CompanyReq;
import com.junmp.jyzb.api.exception.enums.CompanyExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Company;
import com.junmp.jyzb.mapper.CompanyMapper;
import com.junmp.jyzb.service.CompanyService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 09:35
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@Service
public class CompanyServiceImpl extends ServiceImpl<CompanyMapper, Company> implements CompanyService {

    @Override
    public boolean addBiz(CompanyReq req) {
        Company company = new Company();
        BeanPlusUtil.copyProperties(req, company);
        Integer maxSn = baseMapper.getMaxSn();
        //1-获取当前序号
        Integer sn = maxSn + 1;
        company.setSn(sn);
        //2-获取当前编码
        String bizCode = GenCodeUtil.genBizCode(sn);
        company.setBizCode(bizCode);
        return this.save(company);
    }

    @Override
    public boolean editBiz(CompanyReq req) {
        Company company = queryCompany(req);
        BeanPlusUtil.copyProperties(req, company);
        return this.updateById(company);
    }

    @Override
    public boolean del(CompanyReq req) {
        Company entity = queryCompany(req);
        if (ObjectUtil.isNull(entity)) {
            log.warn(StrUtil.format("企业信息不存在,企业编号为：{}", req.getBizId()));
            return false;
        } else {
            return this.removeById(entity.getBizId());
        }
    }

    @Override
    public List<Company> findList(CompanyReq req) {
        LambdaQueryWrapper<Company> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    @Override
    public PageResult<Company> findPage(CompanyReq req) {
        LambdaQueryWrapper<Company> wrapper = createWrapper(req);
        Page<Company> page = this.page(PageFactory.getDefaultPage(), wrapper);
        return PageResultFactory.createPageResult(page);
    }


    private Company queryCompany(CompanyReq req) {
        Company app = this.getById(req.getBizId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(CompanyExceptionEnum.COMPANY_NOT_EXIST);
        }
        return app;
    }


    private LambdaQueryWrapper<Company> createWrapper(CompanyReq req) {
        LambdaQueryWrapper<Company> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getBizCode()), Company::getBizCode, req.getBizCode());
        //根据企业名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), Company::getName, req.getName());
        wrapper.orderByDesc(Company::getCreateTime);
        return wrapper;
    }
}
