package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.Dto.CabinetDto;
import com.junmp.jyzb.api.bean.query.CabinetBoxReq;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.exception.enums.PolicemanExceptionEnum;
import com.junmp.jyzb.exception.enums.PubOrgExceptionEnum;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class CabinetServiceImpl extends ServiceImpl<CabinetMapper, Cabinet> implements CabinetService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private CabinetMapper cabinetMapper;

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;
    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PolicemanService policemanService;

    private static final String REDIS_CABINET = "Cabinet_";



    @Override
    public Map<String, Object> getOneCabinet(String id) {

        return cabinetMapper.getOneCabinet(id);
    }



    //查询某组织机构的所有子机构
    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);//先往List中放入父级id
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }



    @Override
    public ResponseResult changeCabinetState(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("cabinetId"), "cabinetId不能为空");
            checkNotBlank(msg.get("cabinetBoxList"), "cabinetBoxList不能为空");
            List<Map<String, Object>> boxMsg = (List<Map<String, Object>>) msg.get("cabinetBoxList");
            for (Map<String, Object> box : boxMsg) {
                checkNotBlank(box.get("cabinetBoxId"), "cabinetBoxId不能为空");
                checkNotBlank(box.get("state"), "state不能为空");
            }
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        //判断组织机构id是否正确

        CabinetBox cabinetBox = new CabinetBox();
        //读取单警柜id
        cabinetBox.setCabinetId(msg.get("cabinetId").toString());

        //获取cabinetBoxList
        List<Map<String, Object>> boxMsg = (List<Map<String, Object>>) msg.get("cabinetBoxList");
        for (Map<String, Object> box : boxMsg) {
            cabinetBox.setId((String) box.get("cabinetBoxId"));
            cabinetBox.setState((Integer) box.get("state"));
            cabinetBox.setErrorMsg((String) box.get("errorMsg"));
            cabinetBoxMapper.changeCabinetState(cabinetBox);
        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllCabinetBoxId(String id) {
        List<String> msg = cabinetMapper.getAllCabinetBoxId(id);
        return msg;
    }

    @Override
    public ResponseResult getAllCabinet(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("IncludeLowerLevel"), "IncludeLowerLevel不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        List<Map<String, Object>> allCabinet = new ArrayList<>();

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, allCabinet);
    }

    private List<String> getAllOrgId(CabinetReq req, String includeLowerLevel) {
        List<String> allOrg = new ArrayList<>();
        if (includeLowerLevel.equals("false")) {
            allOrg.add(req.getOrgId());
        } else if (includeLowerLevel.equals("true")) {
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(req.getOrgId());
        }
        return allOrg;
    }

    private List<Cabinet> getAllCabinetByOrg( List<String> allOrgId) {
        List<Cabinet> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getAllCabinetByOrgList(allOrgId);
        return allCabinet;
    }
    private List<CabinetDto> getAllCabinetByOrg111( List<String> allOrgId) {
        List<CabinetDto> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getAllCabinetByOrgList111(allOrgId);
        return allCabinet;
    }

    @Override
    public List<String> getAllCabinetId(Map<String, Object> msg) {
        //如果组织机构是最高级的，获取所有id
        if (msg.get("orgId").toString().equals("1369509498032808905")) {
            //构建 Redis 缓存键
            String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
            // 从 Redis 中获取数据
            List<String> cachedData = redisUtils.findCachedData(redisKey);
            if (cachedData != null) {
                return cachedData;
            }
            List<String> allCabinetId = cabinetMapper.getAllCabinetIdByHighest();
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, allCabinetId);
            return allCabinetId;
        }

        //构建 Redis 缓存键
        String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
        // 从 Redis 中获取数据
        List<String> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            return cachedData;
        }
        List<String> cabinetId = new ArrayList<>();
        if (msg.get("IncludeLowerLevel").equals("false")) {
            cabinetId = cabinetMapper.getAllCabinetId(msg.get("orgId").toString());
        } else {
            List<String> orgIds = getSubIds(msg.get("orgId").toString()); //调用本级及下级的所有组织机构的id
            for (String orgId : orgIds) {
                List<String> allPoliceId = cabinetMapper.getAllCabinetId(orgId);
                cabinetId.addAll(allPoliceId);
            }
        }
        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, cabinetId);
        return cabinetId;
    }

    @Override
    public ResponseResult getCabinetDetail(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        String idMsg = msg.get("id").toString();
        Map<String, Object> cabinetMsg = getOneCabinet(idMsg);
        if (cabinetMsg == null) {
            return new ResponseResult(HttpStatus.NO_DATA, ReturnMsg.NO_DATA, ReturnData.NO_DATA);
        }
        List<Map<String, Object>> allBoxMsg = cabinetBoxMapper.getBoxMsg(idMsg);
        cabinetMsg.put("cabinetBoxList", allBoxMsg);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, cabinetMsg);
    }

    public ResponseResult setCabinetInventory(Map<String, Object> msg) {
        String id;
        if (msg.containsKey("locationId") && msg.get("locationId") != "") {
            id = msg.get("locationId").toString();
        } else {
            id = null;
        }
        //统计仓库 装备总数
        cabinetMapper.setCabinetSumInventory(id);
        //统计仓库 装备在库总数
        cabinetMapper.setCabinetInSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetOutSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetPriceInventory(id);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }


    /**
     * 添加单警柜
     *
     * @param req
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String addCabinetInfo(UpdateCabinetReq req) {
        Cabinet cabinet = new Cabinet();
        //查询传入的组织机构id是否存在
        PubOrg puborg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()),PubOrg::getOrgId,req.getOrgId()));
        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        List<Cabinet> list = this.list(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum()));
        if (list.size()>0) {
            //抛出单警柜重复异常
            throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
        }
        BeanPlusUtil.copyProperties(req, cabinet);
        cabinet.setCreateTime(DateTimeUtil.getCurrentDateTime());
        cabinet.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        //添加单警柜
        save(cabinet);
        Cabinet one = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getCabinetNum())), Cabinet::getCabinetNum, req.getCabinetNum())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getOrgId())), Cabinet::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getName())), Cabinet::getName, req.getName()));
        ArrayList<CabinetBox> objects = new ArrayList<>();
        for (int i = 1; i <= req.getNum(); i++) {
            CabinetBox cabinetBox = new CabinetBox();
            cabinetBox.setCabinetId(one.getId());
            cabinetBox.setState(1);
            cabinetBox.setNum(i);
            //添加到列表进行批量增加
            objects.add(cabinetBox);
        }
        cabinetBoxService.saveBatch(objects);
        return cabinet.getId();
    }


    /**
     * 删除单警柜
     *
     * @param req
     * @return
     */
    @Override
    public boolean deleteCabinetInfo(UpdateCabinetReq req) {
        //通过单警柜id查询出他的箱门数
        Cabinet cabinet = this.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), Cabinet::getId, req.getId()));
        //如果查询不到单警柜抛出异常
        if (ObjectUtil.isEmpty(cabinet)) {
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        //通过单警柜id循环遍历出并删除所有箱门信息
        List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getCabinetId, req.getId()));
        for (CabinetBox cabinetBox: list) {
            //删除箱门信息的同时需要去判断箱门是否绑定警员，如果有，则解除绑定
            Policeman one = policemanService.getOne(new LambdaQueryWrapper<Policeman>()
                    .eq(ObjectUtil.isNotEmpty(cabinetBox.getId()),Policeman::getCabinetBoxId,cabinetBox.getId()));
            if (!ObjectUtil.isNull(one)){
                one.setCabinetBoxId(null);
                policemanService.updateById(one);
            }
            cabinetBoxService.removeById(cabinetBox.getId());
        }
        //删除单警柜id
        return this.removeById(cabinet.getId());
    }

    /**
     * 获取单警柜列表
     *通过机构id进行查询
     * @param req 单警柜信息
     * @param req getIncludeLowerLevel true：查询本级及下级  false：查询本级
     * @return
     */
    @Override
    public List<Cabinet> getAllCabinetList(CabinetReq req) {
        List<Cabinet> cabinets = new ArrayList<>();
        //如果组织机构时浙江省公安厅
        if (req.getOrgId().equals("1369509498032808905") && req.getIncludeLowerLevel().equals("true")) {
            cabinets = cabinetMapper.getAllCabinet();
            return cabinets;
        }
        //分两种情况，如果说是本级及下级（全部）所有的单警柜信息，则incluLowerLevel为true，如果是查询本级的单警柜信息则为false
        if (req.getIncludeLowerLevel().equals("true") || req.getIncludeLowerLevel().equals("false")) {
            List<String> allOrgId = getAllOrgId(req, req.getIncludeLowerLevel());
            if (allOrgId.isEmpty()) {
                //抛出组织机构不存在异常
                throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
            }
            cabinets = getAllCabinetByOrg(allOrgId);
            return cabinets;
        } else {
            //传递的数据是否正确，不正确抛异常（只接受true、false）
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
    }


    /**
     * 通过单警柜id查询单个单警柜及其箱门信息
     * @param req
     * @return
     */
    @Override
    public CabinetDto showOneCabinet(CabinetReq req) {
        //查询单警柜信息
        Cabinet one = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), Cabinet::getId, req.getId()));
        if (ObjectUtil.isNull(one)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        //查询单警柜的箱门信息
        List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getCabinetId, req.getId()));
        //将单警柜的信息和它的箱门信息返回
        CabinetDto cabinetDto = new CabinetDto();
        BeanPlusUtil.copyProperties(one,cabinetDto);
        cabinetDto.setList(list);
        return cabinetDto;
    }

    /**
     * 修改单警柜信息
     * 新增箱数
     * @param req
     * @return
     */
    @Override
    public boolean updateCabinetInfo(UpdateCabinetReq req) {
        //查询传入的组织机构id是否存在
        PubOrg puborg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()),PubOrg::getOrgId,req.getOrgId()));
        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        List<Cabinet> list = this.list(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum()));
        if (list.size()>0) {
            //抛出单警柜重复异常
            throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
        }
        Cabinet cabinet = new Cabinet();
        BeanPlusUtil.copyProperties(req, cabinet);
        //如果新增箱门个数，那么对应的箱门表中也需要插入对应对应数量的箱门记录条数
        Cabinet cabinet1 = this.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), Cabinet::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()), Cabinet::getCabinetNum, req.getCabinetNum()));
        Integer oldNum = cabinet1.getNum();
        Integer totalBoxNum = cabinet1.getNum()+req.getNum();
        List<CabinetBox> objects = new ArrayList<>();
        //循环新增箱数信息
        for (int i= oldNum+1;i<=totalBoxNum;i++){
            CabinetBox cabinetBox = new CabinetBox();
            //箱门id
            String id = UUID.randomUUID().toString();
            cabinetBox.setId(id);
            cabinetBox.setCabinetId(req.getId());
            cabinet.setState(1);
            cabinetBox.setNum(i);
            //保存到list
            objects.add(cabinetBox);

        }
        //批量插入
        cabinetBoxService.saveBatch(objects);
        //总箱门数就是原来的箱门数+新增的箱门数
        cabinet.setNum(totalBoxNum);
        return this.updateById(cabinet);
    }

    /**
     * 箱门绑定人员
     * 箱门id-->人员
     * @param req
     * @return
     */
    @Override
    public boolean boxBindPolice(CabinetBoxReq req) {
        //通过箱门id查询出箱门信息
        CabinetBox one = cabinetBoxService.getOne(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getId, req.getId()));
        if (ObjectUtil.isEmpty(one)){
            //箱门id不存在
            throw new ServiceException(CabinetExceptionEnum.CABINETBOX_ISNOT_EXISTS);
        }
        //获取箱门的主柜id
        String cabinetId = one.getCabinetId();
        //通过主柜id获取机构id
        Cabinet one1 = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(cabinetId), Cabinet::getId,cabinetId));
        if (ObjectUtil.isEmpty(one1)){
            //单警柜不存在异常
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        long orgId = one1.getOrgId();
        //通过警员id获取警员所在的机构id
        Policeman one2 = policemanService.getOne(new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(req.getPoliceId()), Policeman::getId, req.getPoliceId()));
        if (ObjectUtil.isEmpty(one2)){
            //警员不存在异常
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        Long orgId1 = one2.getOrgId();
        //判断两个机构id是否相同，相同则可以绑定，不相同则绑定失败
        if (!(orgId1==orgId)){
            return false;
        }
        one2.setCabinetBoxId(one.getId());
        return policemanService.updateById(one2);
    }

    @Override
    public ResponseResult getCabinetByOrgId(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        // 根据组织机构获取该组织机构下所有单警柜
        List<Map<String,Object>> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getCabinetByOrgId(msg.get("orgId").toString());

        // 遍历allCabinet
        for (Map<String,Object> oneCabinet:allCabinet){
            String cabinetId = oneCabinet.get("id").toString();
            // 根据单警柜id获取箱号信息
            List<Map<String,Object>> allBox = new ArrayList<>();
            allBox = cabinetBoxMapper.getBoxMsg(cabinetId);
            oneCabinet.put("allBoxMsg",allBox);
        }

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, allCabinet);
    }



    //查询机构id是否存在
    private LambdaQueryWrapper<PubOrg> PubOrgWrapper(long orgId) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(orgId)) {
            return wrapper;
        }
        //查询机构id是否存在
        wrapper.eq(ObjectUtil.isNotEmpty(orgId),PubOrg::getOrgId,orgId);
        return wrapper;
    }
}