package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.mapper.CabinetBoxMapper;
import com.junmp.jyzb.mapper.PoliceFingerMapper;
import com.junmp.jyzb.mapper.PolicemanMapper;
import com.junmp.jyzb.service.CabinetBoxService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class CabinetBoxServiceImpl extends ServiceImpl<CabinetBoxMapper, CabinetBox> implements CabinetBoxService {

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PoliceFingerMapper policeFingerMapper;

    @Override
    public List<Map<String, Object>> getAllBoxMsg(String id) {
        return cabinetBoxMapper.getBoxMsg(id);
    }

    /**
         * @author lxh
         * @description 通过cabinetId获取箱门信息列表
         * @since 2023/7/18 22:20
         * @param
         * @return
         **/
    @Override
    public List<CabinetBox> getCabinetBoxList(CabinetReq req) {
        List<CabinetBox> cabinetBoxList = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()),CabinetBox::getCabinetId, req.getId()));
        return cabinetBoxList;
    }

}
