package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.ProductTagDto;
import com.junmp.jyzb.api.bean.query.ProductTagReq;
import com.junmp.jyzb.entity.ProductTag;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 09:36
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface ProductTagService extends IService<ProductTag> {

    /**
     * 新增
     *
     * @param req
     */
    boolean addTagInfo(ProductTagReq req);

    /**
     * 编辑
     *
     * @param req
     */
    boolean editTagInfo(ProductTagReq req);

    /**
     * 删除
     *
     * @param req
     */
    boolean del(ProductTagReq req);

    /**
     * 去一条未生产的标签数据
     */
    ProductTag checkTagUid(ProductTagReq req);

    /**
     *
     */
    ProductTag findByUid(String tagUid);

    /**
     * 获取标签信息
     */
    ProductTagDto getTagInfo(Long tagId);

    /**
     * 列表信息
     *
     * @param req
     */
    List<ProductTag> findList(ProductTagReq req);

    /**
     * 分页信息
     *
     * @param req
     */
    PageResult<ProductTag> findPage(ProductTagReq req);
}
