package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.Dto.CabinetDto;
import com.junmp.jyzb.api.bean.query.CabinetBoxReq;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.utils.ResponseResult;

import java.util.List;
import java.util.Map;

public interface CabinetService extends IService<Cabinet> {




    List<String> getAllCabinetId(Map<String, Object> orgId);

    Map<String, Object> getOneCabinet(String cabinetId);


    ResponseResult changeCabinetState(Map<String, Object> msg);

    List<String> getAllCabinetBoxId(String id);

    ResponseResult getAllCabinet(Map<String, Object> msg);

    ResponseResult getCabinetDetail(Map<String, Object> msg);

    ResponseResult setCabinetInventory(Map<String, Object> msg);

    /**
     * 添加单警柜
     * @param req
     * @return
     */
    String addCabinetInfo(UpdateCabinetReq req) ;

    /**
     * 删除单警柜
     * @param req
     * @return
     */
    boolean deleteCabinetInfo(UpdateCabinetReq req);

    /**
     * 查询单警柜信息，通过组织机构id进行查询
     * @param req
     * @return
     */
    List<Cabinet> getAllCabinetList(CabinetReq req);



    /**
     * 通过单警柜id进行查询单个单警柜信息及其箱门信息
     * @param req
     * @return
     */
    CabinetDto showOneCabinet(CabinetReq req);

    /**
     * 修改单警柜信息
     * @param req
     * @return
     */
    boolean updateCabinetInfo(UpdateCabinetReq req);

    /**
     * 箱门绑定人员
     * @param req
     * @return
     */
    boolean boxBindPolice(CabinetBoxReq req);

    /**
     * 根据组织机构获取单警柜及箱号信息
     * @param msg
     * @return
     */
    ResponseResult getCabinetByOrgId(Map<String, Object> msg);
}
