package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.ProductBatchDto;
import com.junmp.jyzb.api.bean.dto.ProductProcessDto;
import com.junmp.jyzb.api.bean.query.ProductBatchReq;
import com.junmp.jyzb.entity.ProductBatch;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/30 13:43
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Mapper
public interface ProductBatchMapper extends BaseMapper<ProductBatch> {

    /**
     * 获取当前最大序号
     */
    Integer getMaxSn();


    /**
     * 指定批次的生成进度
     *
     * @param batchId 批次号
     */
    ProductBatchDto getBatchProcess(@Param("batchId") Long batchId);



    /**
     * 分页
     *
     * @param page
     * @param req
     */
    Page<ProductBatchDto> getBatchPage(@Param("page") Page<ProductBatchDto> page, @Param("batch") ProductBatchReq req);


    /**
     * 分页
     *
     * @param page
     * @param req
     */
    Page<ProductProcessDto> getBatchProcessPage(@Param("page") Page<ProductProcessDto> page, @Param("batch") ProductBatchReq req);


}
