package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.ShelfReq;
import com.junmp.jyzb.api.bean.query.WarehouseAreaReq;
import com.junmp.jyzb.api.bean.query.WarehouseReq;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Warehouse")
@Api(tags = "仓库基础信息模块")
public class WarehouseController {
    @Resource
    public WarehouseService warehouseService;

    @Resource
    public WarehouseAreaService warehouseAreaService;

    @Resource
    public ShelfService shelfService;

//    @PostMapping("/AddWarehouse")
//    @ApiOperation("添加仓库")
//    public ResponseResult addWarehouse(@RequestBody Map<String,Object> msg) {
//        ResponseResult returnMsg = warehouseService.addWarehouse(msg);
//        return returnMsg;
//    }

    @PostMapping("/AddWarehouse")
    @ApiOperation("添加仓库")
    public ApiRes<Boolean> addWarehouse(@RequestBody @Validated(WarehouseReq.add.class) WarehouseReq req) {
        //ResponseResult returnMsg = warehouseService.addWarehouse(msg);
        return ApiRes.success(warehouseService.addWarehouse(req));
    }

//    @PostMapping("/DeleteWarehouse")
//    @ApiOperation("删除仓库信息")
//    public ResponseResult deleteWarehouse(@RequestBody Map<String,Object> msg) {
//        ResponseResult returnMsg = warehouseService.deleteWarehouse(msg);
//        return returnMsg;
//    }

    @PostMapping("/DeleteWarehouse")
    @ApiOperation("删除仓库信息")
    public ApiRes<Boolean> deleteWarehouse(@RequestBody @Validated(WarehouseReq.delete.class)WarehouseReq req) {
        //ResponseResult returnMsg = warehouseService.deleteWarehouse(msg);
        return ApiRes.success(warehouseService.deleteWarehouse(req));
    }

    @PostMapping("/ChangeWarehouseState")
    @ApiOperation("禁用/启用仓库")
    public ApiRes<Boolean> changeWarehouseState(@RequestBody @Validated(WarehouseReq.edit.class) WarehouseReq req) {
        return ApiRes.success(warehouseService.changeWarehouseState(req));
    }

    @PostMapping("/ShowWarehouse")
    @ApiOperation("查询仓库列表")
    public ApiRes<List<Warehouse>> getAllWarehouse(@RequestBody WarehouseReq req){
        return ApiRes.success(warehouseService.getAllWarehouse(req));

//        //获取该组织机构下所有警员的id
//        List<Map<String, Object>> allWarehouse=new ArrayList<>();
//        List<String> allWarehouseId =warehouseService.getAllWarehouseId(orgId);
//        for (String warehouseId :allWarehouseId){
//            Map<String, Object> warehouseMsg = warehouseService.getOneWarehouse(warehouseId);
//            allWarehouse.add(warehouseMsg);
//        }
//        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allWarehouse);
    }

    @PostMapping("/GetWarehouseDetail")
    @ApiOperation("查询单个仓库信息")
    public ApiRes<Warehouse> getOneWarehouse(@RequestBody @Validated(WarehouseReq.detail.class)WarehouseReq req) {
        return ApiRes.success(warehouseService.getOneWarehouse(req));
    }

    @PostMapping("/UpdateWarehouse")
    @ApiOperation("修改仓库信息")
    public ApiRes<Boolean> updateWarehouse(@RequestBody @Validated(WarehouseReq.edit.class) WarehouseReq req) {
        return ApiRes.success(warehouseService.updateWarehouse(req));
    }

    @PostMapping("/AddArea")
    @ApiOperation("添加区域")
    public ApiRes<Boolean> addArea(@RequestBody @Validated(WarehouseAreaReq.add.class) WarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.addArea(req));
    }

    @PostMapping("/UpdateArea")
    @ApiOperation("修改区域")
    public ApiRes<Boolean> updateArea(@RequestBody @Validated(WarehouseAreaReq.edit.class) WarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.updateArea(req));
    }

    @PostMapping("/DeleteArea")
    @ApiOperation("删除区域")
    public ApiRes<Boolean> deleteArea(@RequestBody @Validated(WarehouseAreaReq.delete.class) WarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.deleteArea(req));
    }

    @PostMapping("/GetAreaList")
    @ApiOperation("查询区域信息")
    public ApiRes<List<WarehouseArea>> getAreaList(@RequestBody WarehouseAreaReq req){
        return ApiRes.success(warehouseAreaService.getAreaList(req));
    }


    @PostMapping("/AddShelf")
    @ApiOperation("添加货架")
    public ApiRes<Boolean> addShelf(@RequestBody @Validated(ShelfReq.add.class) ShelfReq req) {
        return ApiRes.success(shelfService.addShelf(req));
    }

    @PostMapping("/UpdateShelf")
    @ApiOperation("修改货架")
    public ApiRes<Boolean> updateShelf(@RequestBody @Validated(ShelfReq.edit.class) ShelfReq req) {
        return ApiRes.success(shelfService.updateShelf(req));
    }

    @PostMapping("/DeleteShelf")
    @ApiOperation("删除货架")
    public ApiRes<Boolean> deleteShelf(@RequestBody @Validated(ShelfReq.delete.class) ShelfReq req) {
        return ApiRes.success(shelfService.deleteShelf(req));
    }

    @PostMapping("/GetShelfList")
    @ApiOperation("查询区域信息")
    public ApiRes<List<Shelf>> getShelfList(@RequestBody ShelfReq req){
        return ApiRes.success(shelfService.getShelfList(req));
    }
}
