package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.dto.PoliceDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.req.UpdatePolicemanReq;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Police")
@Api(tags = "警员基础信息模块")
public class PoliceController {

    @Resource
    public PolicemanService policemanService;

    @PostMapping("/AddPoliceman")
    @ApiOperation("添加警员信息")
    public ApiRes<String> AddPoliceman(@RequestBody UpdatePolicemanReq req) {
        String policeId = policemanService.AddPoliceman(req);
        return ApiRes.success(policeId);
    }

    @PostMapping("/DeletePolice")
    @ApiOperation("删除警员信息")
    public ApiRes<Boolean> DeletePolice(@RequestBody UpdatePolicemanReq req) {
        boolean b = policemanService.DeletePolice(req);
        if (!b){
            return ApiRes.failure("删除失败");
        }
        return ApiRes.success(b);
    }


    @PostMapping("/ChangePoliceState")
    @ApiOperation("修改警员状态")
    public ApiRes<Boolean> ChangePoliceState(@RequestBody UpdatePolicemanReq req) {
        boolean b = policemanService.ChangePoliceState(req);
        if (!b){
            return ApiRes.failure("修改失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/UpdatePolice")
    @ApiOperation("修改警员信息")
    public ApiRes<Boolean> UpdatePolice(@RequestBody UpdatePolicemanReq req) {
        boolean b = policemanService.UpdatePolice(req);
        if (!b){
            return ApiRes.failure("修改失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/ShowPolice")
    @ApiOperation("查询警员列表")  //根据组织机构id查询
    public ResponseResult getAllPoliceman(@RequestBody Map<String, Object> orgId){
        ResponseResult returnMsg = policemanService.getAllPoliceman(orgId);
        return returnMsg;
    }


    //根据组织机构id查询,只查询本级，不包含下级
     @PostMapping("/ShowPoliceList")
    @ApiOperation("查询某个组织机构下的所有警员信息")
    public ApiRes<PoliceDto> GetAllPolicemanList(Long orgId){
         PoliceDto policeDto = policemanService.GetAllPolicemanList(orgId);
         return ApiRes.success(policeDto);
     }



    /**
     * 通过警员id查询警员信息
     * @param req
     * @return
     */
    @PostMapping("/GetPoliceDetail")
    @ApiOperation("查询单个警员信息")
    public ApiRes<PolicemanDto> GetOnePolice(@RequestBody PolicemanReq req) {
        return ApiRes.success(policemanService.GetOnePolice(req));
    }


    /**
     * 根据单警柜id查询出单警柜下面箱门绑定的警员信息
     * @param
     * @return
     */
    @PostMapping("/GetPoliceData")
    @ApiOperation("查询与单警柜绑定的警员信息")  //根据单警柜id查询
    public ApiRes<PoliceDto> GetPoliceData(String id){
        //获取该组织机构下所有警员的id
        PoliceDto policeDto = policemanService.GetPoliceData(id);
        return ApiRes.success(policeDto);
    }



    @PostMapping("/ChangePoliceOrg")
    @ApiOperation("警员调岗")
    public ResponseResult changePoliceOrg(@RequestBody Map<String, Object> cabinetId){

        return null;
    }


    @PostMapping("/AddFaceInfo")
    @ApiOperation("添加警员面部信息")
    public ApiRes<Boolean> AddFaceInfo(@RequestBody PolicemanReq req) {
        boolean b = policemanService.AddFaceInfo(req);
        if (!b){
            return ApiRes.failure("添加失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/UpdateFaceInfo")
    @ApiOperation("修改、删除人脸信息")
    public ApiRes<Boolean> UpdateFaceInfo(@RequestBody UpdatePolicemanReq req) {
        boolean b = policemanService.UpdateFaceInfo(req);
        if (!b){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/SearchFaceInfo")
    @ApiOperation("查找人脸信息")
    public ApiRes<Policeman> SearchFaceInfo(@RequestBody PolicemanReq req) {
        Policeman policeman = policemanService.SearchFaceInfo(req);
        if (ObjectUtil.isEmpty(policeman)){
            return ApiRes.failure("未找到警员信息");
        }
        return ApiRes.success(policeman);
    }

    //警员绑定账号
    @PostMapping("/PoliceBindUser")
    @ApiOperation("警员绑定账号")
    public ApiRes<Boolean> PoliceBindUser(@RequestBody PolicemanReq req){
        boolean b = policemanService.PoliceBindUser(req);
        if (!b){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(b);
    }

    /**
     * 人员绑定箱门
     */
    @PostMapping("/PoliceBindBox")
    @ApiOperation("人员绑定箱门")
    public ApiRes<Boolean> PoliceBindBox(@RequestBody @Validated(ValidationApi.edit.class) PolicemanReq req){
        boolean b = policemanService.PoliceBindBox(req);
        if (!b){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(b);
    }
}
