package com.junmp.jyzb.Dto;

import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.v2.common.bean.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class CabinetDto extends BaseRequest {
    /**
     * 单警柜ID
     */
    @ApiModelProperty(value = "单警柜ID")
    private String id;

    /**
     * 单警柜编号
     */
    @ApiModelProperty(value = "单警柜编号")
    private String cabinetNum;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱数")
    private Integer num;

    /**
     * 单警柜名称
     */
    @ApiModelProperty(value = "单警柜名称")
    private String name;

    /**
     * 组织机构号
     */
    @ApiModelProperty(value = "组织机构号")
    private String orgId;

    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String location;

    /**
     * 单警柜当前状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜当前状态，0正常，1异常")
    private Integer state;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    private String updateUser;

    /**
     * 是否包含本级及下级，true为包含，false为不包含，只显示本级
     */
    @ApiModelProperty(value = "本机及下级")
    private String includeLowerLevel;

    /**
     * 单警柜与箱门一对多关系
     */
     private List<CabinetBox> list ;

    private static final long serialVersionUID = 1L;
}