package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class PolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {edit.class, delete.class, detail.class})
    private String id;

    private String name;

    @NotBlank(message = "箱门id不能为空", groups = {edit.class, delete.class, detail.class})
    private String cabinetBoxId;

    private Long orgId;

    private Long departmentId;

    private String policeCode;

    private String sex;

    private String faceInfo;

    private Boolean isCreatedAccount;

    private String doorCode;

    //账号
    private String account;

    //密码
    private String password;

    private String photo;

    private String phone;

    private Date createTime;

    private Date updateTime;

    private String idCard;

    private String updateUser;

    private Integer state;

    private static final long serialVersionUID = 1L;
}