package com.junmp.junmpProcess.mapper;

import com.junmp.junmpProcess.entity.QuickSuggestions;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.query.QueryOrderLogReq;
import com.junmp.jyzb.api.bean.req.InventorySummaryReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【flw_quick_suggestions(快选意见表（审核流审批时的意见表）)】的数据库操作Mapper
* @createDate 2023-11-27 13:28:59
* @Entity com.junmp.junmpProcess.entity.QuickSuggestions
*/
public interface QuickSuggestionsMapper extends BaseMapper<QuickSuggestions> {

    void updateOrderMain(@Param("processId") String processInstanceId);

    void updateBusForm(@Param("processId") String processInstanceId);

    void updateReassignment(@Param("processId")String processInstanceId);

    UpdateBusFormReq getBusForm(@Param("processId")String processInstanceId);

    List<InventorySummaryReq> selectSumByItems(@Param("list") List<Object[]> searchItem);

    void updateInventorySum(@Param("list") List<InventorySummaryReq> inventorySummaryList);

    List<UpdateOrderDetailReq> getOrderMainDetail(@Param("processId")String processInstanceId);

    boolean updateDesNum(@Param("list") List<InventorySummaryReq> inventorySummaryList);

    Boolean addOrderLog(@Param("req") QueryOrderLogReq orderLog);
}




