package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.query.InAndOutRecordReq.CabinetLogsRecordReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.SelectTotalNumReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

public interface InventorySummaryService extends IService<InventorySummary> {



    //根据条件查询库存汇总信息
    PageResult<InventorySummary> getEquipmentInfo(InventorySumReq req);
    List<InventorySummary> getEquipmentInfoList(InventorySumReq req);
    //根据条件查询装备汇总信息，用于出库单的选择装备
    List<InventorySumDto> GetInventorySumInfo(InventorySumReq req);

    InventorySummary getOne(InventorySumReq req);

    //对summary表中数据进行重新计算装备信息汇总
    Boolean updateSummaryInsByOrder(Long orgId);

    //处理单警柜返回单据结果
    Boolean cabinetInOutRecords(CabinetLogsRecordReq req);

    //根据组织机构id/单警柜id/仓库id查询出库存汇总数量以及金额
    List<InventorySummary> getTotalNumberAndPrice(InventorySumReq req);

    //计算装备总数（装备数量数据统计）
    List<InventorySummary> EquipmentStatistics(InventorySumReq req);

    //通过条件查询库存汇总
    List<InventorySummary> selectSumByItems(SelectTotalNumReq req);


    boolean insertToSummary();

    List<InventorySumDto> selectTotalNum(SelectTotalNumReq req);



    //根据条件查询库存汇总信息（仅类型）
    PageResult<InventorySummary> GetEquipmentSummary(InventorySumReq req);

    List<InventorySummary> GetEquipmentSummaryDetail(InventorySumReq req);


    void setDestoryGroupAction();

    void setWarrantyGroupAction();
}
