package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum InventoryExceptionEnum implements IExceptionEnum {
    INVENTORY_NOT_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"装备信息不存在"),
    INVENTORY_BEYOND_STOCK(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"填写的报废的装备数量大于实际能进行报废的数量"),
    BROKENNUM_BEYOND_STOCK(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"审核中的数量已存在最大可报废数量，现提交失败"),
    ORDER_NOT_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"盘点单据不存在"),
    ORDER_Child_NOT_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"盘点子单据不存在"),
    ORDER_HAS_START(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"单据已经开始，请勿重复操作"),
    RUNNINGORDER_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"已存在盘点单"),
    ORDER_CLOSED(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"单据已结算，无法重复操作"),
    ACCOUNT_ERROR(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"人工新增物资未编辑，请先编辑物资信息"),
    INVERTORY_IS_NULL(CommonConstant.DEFAULT_USER_ERROR_CODE,"导入的装备为空"),
    /**
     * 装备不存�
     */
    EQUIPMENT_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 13, "{}")
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    InventoryExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
