package com.junmp.jyzb.api.bean.query;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class InventoryReq extends BaseRequest {


    @NotBlank(message = "装备id不能为空",groups = {detail.class})
    private String id;
    /**
     * 装备包ID
     */
    private String packageId;

    /**
     * 装备类型ID
     */
    private String typeId;
    /**
     * 装备类型名称
     */
    private String typeName;
    /**
     * 装备号型ID
     */
    private String sizeId;
    /**
     * 装备号型
     */
    private String sizeName;
    /**
     * 供应商
     */
    private String supplierName;
    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 货架位置
     */
    private String shelfLocation;

    /**
     * 货架位置
     */
    @NotBlank(message = "货架id不能为空",groups = {list.class})
    private String shelfId;

    /**
     * epc
     */
    @NotBlank(message = "epc不能为空",groups = {page.class})
    private String epc;

    /**
     * 组织机构ID
     */
    @NotNull(message = "组织机构不能为空",groups = {export.class})
    private Long orgId;

    private String orgName;
    /**
     * 单警柜id
     */
    private String cabinetId;
    /**
     * 仓库id
     */
    private String warehouseId;
    /**
     * 查询类型，org:组织机构，warehouse：仓库，cabinet：单警柜
     */
    @NotBlank(message = "查询类型不能为空",groups = {edit.class})
    private String queryType;
    /**
     * 物资状态
     */
    private String state;

    /**
     * 业务状态
     */
    private String bussinessState;

    /**
     * 在库状态
     */
    private String locationState;

    /**
     * 生产日期
     */
    private Date productionDate;

    /**
     * 质保期
     */
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    private Integer maintenancePeriod;

    /**
     * 维修次数
     */
    private Integer fixCount;
    /**
     * 超期状态(-1查询全部的物资，包括超期的物资，0是未超期的物资，1为已超期的物资)
     */
    @NotNull(message = "超期状态不能为空",groups = {export.class})
    private Integer termState;
    /**
     * 位置类型
     */
    private String locationType;

    /**
     * 位置ID
     */
    private String locationId ;
    private String locationName;
    /**
     * 是否遗失
     */
    private Integer lostFlag ;
    /**
     * 价格
     */
    private BigDecimal price ;

    /**
     * 标签id
     */
    private String tid ;

    /**
     * 备注
     */
    private String note ;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Long updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * EPC集合
     */
    private List<String> epcList;

    private Boolean isCreateNullDate;

    private List<String> typeIdList;
    private List<String> sizeIdList;

    private List<InventoryReq> eqsList;

    private String startTime;
    private String endTime;

    private Integer zkCount;

    private Integer stockNum;

    private Integer outBoundNum;

    private Integer property;

    private String bussinessType;

    private String number;

}
