package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.PoliceDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.UserDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.dto.ReassignmentDto;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.query.QueryReassignmentReq;
import com.junmp.jyzb.api.bean.req.UpdatePolicemanReq;
import com.junmp.jyzb.api.bean.req.UpdateReassignmentReq;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.entity.PoliceEquipment;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.Reassignment;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.sys.api.bean.user.SysUserDto;
import com.junmp.v2.sys.api.bean.user.req.SysUserReq;
import com.junmp.v2.sys.api.bean.user.req.UserOrgReq;
import com.junmp.v2.sys.user.controller.SysUserController;
import com.junmp.v2.sys.user.service.SysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import liquibase.pro.packaged.B;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Police")
@Api(tags = "[基础信息]警员基础信息模块")
public class PoliceController {

    @Resource
    public PolicemanService policemanService;

    @PostMapping("/AddPoliceman")
    @ApiOperation("添加警员信息")
    public ApiRes<String> AddPoliceman(@RequestBody @Validated(ValidationApi.add.class) UpdatePolicemanReq req) {
        String policeId = policemanService.AddPoliceman(req);
        return ApiRes.success(policeId);
    }
    //添加警员时先将没有组织机构号的警员查询出来
    @PostMapping(path="/GetPoliceWithoutOrg",name="获取没有组织机构的警员信息#enable")
    @ApiOperation("/获取没有组织机构的警员信息")
    public ApiRes<List<Policeman>> GetPoliceWithoutOrg(){
        return ApiRes.success(policemanService.GetPoliceWithoutOrg());
    }

    @PostMapping("/DeletePolice")
    @ApiOperation("删除警员信息")
    public ApiRes<Boolean> DeletePolice(@RequestBody @Validated(ValidationApi.delete.class) UpdatePolicemanReq req) {
        boolean b = policemanService.DeletePolice(req);
        if (!b){
            return ApiRes.failure("删除失败");
        }
        return ApiRes.success(b);
    }

    //添加人脸和指纹照片或修改
    @PostMapping("/addFaceAndfinger")
    @ApiOperation("添加警员人脸照片和指纹照片")
    public ApiRes<Boolean> addFaceAndfinger(@RequestBody UpdatePolicemanReq req){
        return ApiRes.success(policemanService.addFaceAndfinger(req));
    }


    @PostMapping("/ChangeUserState")
    @ApiOperation("修改账号状态")
    public ApiRes<Boolean> ChangeUserState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdatePolicemanReq req) {
        boolean b = policemanService.ChangePoliceState(req);
        if (!b){
            return ApiRes.failure("修改失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/UpdatePolice")
    @ApiOperation("修改警员信息")
    public ApiRes<Boolean> UpdatePolice(@RequestBody @Validated(ValidationApi.edit.class) UpdatePolicemanReq req) {
        boolean b = policemanService.UpdatePolice(req);
        if (!b){
            return ApiRes.failure("修改失败");
        }
        return ApiRes.success(b);
    }
    //重置密码
    @PostMapping("/reSetPassword")
    @ApiOperation("重置密码")
    public ApiRes<Boolean> reSetPassword(@RequestBody @Validated(SysUserReq.resetPwd.class) SysUserReq req){
        return ApiRes.success(policemanService.reSetPassword(req));
    }
    //修改密码
    @PostMapping("/updatePassword")
    @ApiOperation("修改密码")
    public ApiRes<Boolean> updatePassword(@RequestBody @Validated(SysUserReq.updatePwd.class) SysUserReq req){
        return ApiRes.success(policemanService.updatePassword(req));
    }



    //根据条件查询,只查询本级，不包含下级(list)

    @PostMapping(path="/ShowPoliceList",name="根据条件查询所有警员信息#enable")
    @ApiOperation("根据条件查询所有警员信息(list)")
    public ApiRes<List<PolicemanDto>> GetAllPolicemanList(@RequestBody PolicemanReq req){
        List<PolicemanDto> policemanDtos = policemanService.GetAllPolicemanList(req);
        return ApiRes.success(policemanDtos);
     }

    //根据组条件查询,只查询本级，不包含下级(page)--可以根据组织机构查询
    @PostMapping(path="/ShowPolicePage",name="根据条件查询所有警员信息#enable")
    @ApiOperation("根据条件查询所有警员信息(page)")
    public ApiRes<PageResult<PolicemanDto>> GetAllPolicemanPage(@RequestBody @Validated(ValidationApi.page.class) PolicemanReq req){
        PageResult<PolicemanDto> policemanDtoPageResult = policemanService.GetAllPolicemanPage(req);
        return ApiRes.success(policemanDtoPageResult);
    }


    /**
     * 通过警员id查询警员信息
     * @param req
     * @return
     */

    @PostMapping(path="/GetPoliceDetail",name="查询单个警员信息#enable")
    @ApiOperation("查询单个警员信息")
    public ApiRes<PolicemanDto> GetOnePolice(@RequestBody @Validated(ValidationApi.detail.class) PolicemanReq req) {
        return ApiRes.success(policemanService.GetOnePolice(req));
    }


    /**
     * 根据单警柜id查询出单警柜下面箱门绑定的警员信息(list)
     * @param
     * @return
     */

    @PostMapping(path="/GetPoliceData",name="查询与单警柜绑定的警员信息#enable")
    @ApiOperation("查询与单警柜绑定的警员信息(list)")  //根据单警柜id查询
    public ApiRes<List<PolicemanDto>> GetPoliceData(@RequestBody CabinetReq req){
        //获取该单警柜下所有警员的id
        List<PolicemanDto> policemanDtos = policemanService.GetPoliceData(req);
        return ApiRes.success(policemanDtos);
    }

    @PostMapping(path="/GetPoliceDataPage",name="查询与单警柜绑定的警员信息#enable")
    @ApiOperation("查询与单警柜绑定的警员信息(page)")  //根据单警柜id查询
    public ApiRes<PageResult<PolicemanDto>> GetPoliceDataPage(@RequestBody CabinetReq req){
        //获取该单警柜下所有警员的id
        return ApiRes.success(policemanService.GetPoliceDataPage(req));
    }


    @PostMapping("/AddFaceInfo")
    @ApiOperation("添加警员面部信息")
    public ApiRes<Boolean> AddFaceInfo(@RequestBody @Validated(ValidationApi.detail.class) UpdatePolicemanReq req) {
        boolean b = policemanService.AddFaceInfo(req);
        if (!b){
            return ApiRes.failure("添加失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/UpdateFaceInfo")
    @ApiOperation("修改、删除人脸信息")
    public ApiRes<Boolean> UpdateFaceInfo(@RequestBody @Validated(ValidationApi.delete.class) UpdatePolicemanReq req) {
        boolean b = policemanService.UpdateFaceInfo(req);
        if (!b){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(b);
    }


    @PostMapping(path="/SearchFaceInfo",name="查找人脸信息#enable")
    @ApiOperation("查找人脸信息")
    public ApiRes<Policeman> SearchFaceInfo(@RequestBody @Validated(ValidationApi.detail.class) PolicemanReq req) {
        Policeman policeman = policemanService.SearchFaceInfo(req);
        if (ObjectUtil.isEmpty(policeman)){
            return ApiRes.failure("未找到警员信息");
        }
        return ApiRes.success(policeman);
    }

    //查询组织机构下的用户以及角色信息(也可以根据别的查询条件查询)

    @PostMapping(path="/ShowUserRole",name="查询用户角色信息#enable")
    @ApiOperation("查询用户角色信息")
    public ApiRes<PageResult<SysUserDto>> ShowUserRole(@RequestBody SysUserReq req){
        return ApiRes.success( policemanService.ShowUserRole(req));
    }

    /**
     * 人员绑定箱门
     */
    @PostMapping("/PoliceBindBox")
    @ApiOperation("人员绑定箱门")
    public ApiRes<Boolean> PoliceBindBox(@RequestBody @Validated(ValidationApi.add.class) PolicemanReq req){
        return ApiRes.success(policemanService.PoliceBindBox(req));
    }


    //删除账号的同时，将警员的信息进行更新
    @PostMapping("/UpdatePoliceInfo")
    @ApiOperation("删除警员账号，修改警员信息")
    public ApiRes<Boolean> UpdatePoliceInfo (@RequestBody UserOrgReq req){
        return ApiRes.success(policemanService.UpdatePoliceInfo(req));
    }

    //将警员和user一一对应并且关系表也一一对应
    @PostMapping("/UpdatePoliceUser")
    @ApiOperation("将警员关系一一对应")
    public ApiRes<Boolean> UpdatePoliceUser(){
        return ApiRes.success(policemanService.UpdatePoliceUser());
    }


    @PostMapping("/PoliceReassignment")
    @ApiOperation("警员调岗申请单")
    public ApiRes<String> PoliceReassignment(@RequestBody UpdateReassignmentReq req){
        return ApiRes.success(policemanService.PoliceReassignment(req));
    }


    @PostMapping(path="/ShowReassignmentPage",name="查看警员调岗申请单#enable")
    @ApiOperation("查看警员调岗申请单")
    public ApiRes<PageResult<Reassignment>> ShowReassignmentPage(@RequestBody QueryReassignmentReq req){
        return ApiRes.success(policemanService.ShowReassignmentPage(req));
    }

    @PostMapping("/ChangePoliceOrg")
    @ApiOperation("警员调岗（业务过程）")
    public ApiRes<Boolean> changePoliceOrg(@RequestBody UpdateReassignmentReq req){
        return ApiRes.success(policemanService.changePoliceOrg(req));
    }


    //获取警员的装备信息

    @PostMapping(path="/GetPoliceEquipment",name="获取警员装备信息#enable")
    @ApiOperation("获取警员装备信息")
    public ApiRes<List<PoliceEquipment>> GetPoliceEqs(@RequestBody QueryReassignmentReq req){
        return ApiRes.success(policemanService.GetPoliceEqs(req));
    }

    //查询组织机构为null的警员

    @PostMapping(path="/getPoliceWithoutOrg",name="查询组织机构为空的警员#enable")
    @ApiOperation("查询组织机构为空的警员")
    public ApiRes<List<PolicemanDto>> getPoliceWithoutOrg(){
        return ApiRes.success(policemanService.getPoliceWithoutOrg());
    }


    @PostMapping("/alignPoliceInfo")
    @ApiOperation("同步更新警员信息")
    public ApiRes<List<PoliceDto>> alignPoliceInfo(@RequestBody PolicemanReq req){
        return ApiRes.success(policemanService.alignPoliceInfo(req));
    }

    @PostMapping("/alignUserInfo")
    @ApiOperation("同步更新用户信息")
    public ApiRes<List<UserDto>> alignUserInfo(@RequestBody PolicemanReq req){
        return ApiRes.success(policemanService.alignUserInfo(req));
    }

}
