package com.junmp.jyzb.api.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;

import java.util.Date;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:36
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public class GenCodeUtil {

    private static final String QY_PREFIX = "11";
    private static final String PRODUCT_PREFIX = "99";
    private static final String HX_PREFIX = "1";

    /**
     * 字符串前面补零操作
     *
     * @param str 字符串本体
     * @param len 需要的字符串总长度
     * @return
     */
    public static String splicingZero(String str, int len) {
        int strLen = str.length();
        String strReturn = str;
        for (int i = 0; i < len - strLen; i++) {
            strReturn = "0" + strReturn;
        }
        return strReturn.toUpperCase();
    }

    /**
     * 生成企业代码
     *
     * @param sn 当前序号(11)
     */
    public static String genBizCode(Integer sn) {
        StringBuilder sb = new StringBuilder();
        sb.append(QY_PREFIX);
        sb.append(splicingZero(String.valueOf(sn), 4));
        return sb.toString();
    }

    /**
     * 生成产品代码
     *
     * @param sn 当前序号(11)
     */
    public static String genProductCode(Integer sn) {
        StringBuilder sb = new StringBuilder();
        sb.append(PRODUCT_PREFIX).append(splicingZero(String.valueOf(sn), 4));
        return sb.toString();
    }

    /**
     * 生成号型代码
     *
     * @param sn 当前序号(11)
     */
    public static String genSpecCode(Integer sn) {
        StringBuilder sb = new StringBuilder();
        sb.append(HX_PREFIX).append(splicingZero(String.valueOf(sn), 3));
        return sb.toString();
    }

    /**
     * 生产批次号
     */
    public static String genBatchNo(Integer sn) {
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtil.format(new Date(), DatePattern.PURE_DATE_PATTERN))
                .append(splicingZero(String.valueOf(sn), 4));
        return sb.toString();
    }

    /**
     * 生产SKU
     *
     * @param productCode
     * @param hxCode
     */
    public static String genSkuCode(String productCode, String hxCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(productCode).append(hxCode);
        return sb.toString();
    }
}
