package com.junmp.junmpProcess.controller;

import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.dto.ApplyDTO;
import com.junmp.junmpProcess.dto.HandleDataDTO;
import com.junmp.junmpProcess.dto.TaskDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.junmpProcess.service.IFlowTaskService;
import com.junmp.junmpProcess.vo.HistoryProcessInstanceVO;
import com.junmp.junmpProcess.vo.RecordVO;
import com.junmp.junmpProcess.vo.TaskDetailVO;
import com.junmp.junmpProcess.vo.TaskVO;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/FlowTask")
@Api(tags = "流程任务")
public class FlowTaskController {
    @Autowired
    private IFlowTaskService FlowTaskService;
    @ApiOperation("同意按钮")
    @PostMapping("agree")
    public ResponseResult agree(@RequestBody HandleDataDTO handleDataDTO){
        return FlowTaskService.agree(handleDataDTO);
    }
    @ApiOperation("拒绝按钮")
    @PostMapping("refuse")
    public ResponseResult refuse(@RequestBody HandleDataDTO handleDataDTO){
        return FlowTaskService.refuse(handleDataDTO);
    }
    @ApiOperation("撤销按钮")
    @PostMapping("revoke")
    public ResponseResult revoke(@RequestBody HandleDataDTO handleDataDTO){
        return FlowTaskService.revoke(handleDataDTO);
    }
    @ApiOperation("查看我的待办")
    @PostMapping("toDoList")
    public ApiRes<PageResult<TaskVO>> toDoList(@RequestBody TaskDTO taskDTO){
        return ApiRes.success(FlowTaskService.toDoList(taskDTO));
    }
    @ApiOperation("查看我的已办")
    @PostMapping("doneList")
    public ApiRes<PageResult<TaskVO>> doneList(@RequestBody TaskDTO taskDTO){
        return ApiRes.success(FlowTaskService.doneList(taskDTO));
    }
    @ApiOperation("查看我发起的流程")
    @PostMapping("applyList")
    public ApiRes<PageResult<HistoryProcessInstanceVO>> applyList(@RequestBody ApplyDTO ApplyDTO) {
        return ApiRes.success(FlowTaskService.applyList(ApplyDTO));
    }

    @ApiOperation("通过流程实例查看审批记录")
    @PostMapping("record")
    public ApiRes<RecordVO> record(@RequestBody HandleDataDTO handleDataDTO) {

        return FlowTaskService.record(handleDataDTO.getProcessInstanceId());
    }
}
