package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 盘库申请实体类
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class StocktakeReq extends BaseRequest {
    /**
     * id
     */
    private String id;

    /**
     * 工作流
     */
    private String processId;

    /**
     * 单据业务类型：盘库stocktake
     */
    private String bussinessType;

    /**
     * 单据单号
     */
    private String orderCode;

    /**
     * 组织机构id
     */
    @NotNull(message = "组织机构id不能为空",groups = {detail.class})
    private Long orgId;


    /**
     * 组织机构名称
     */
    private String orgName;


    /**
     * 仓库名称
     */
    private String locationName;
    /**
     * 仓库id
     */
    private String locationId;
    /**
     * 盘库类型（0全盘，1根据货架位置盘，2根据装备类型盘）
     */
    private Integer stocktakeType;

    /**
     * 货架id（类型为1时特有）
     */
    private String shelfId;

    /**
     * 排（类型为1时特有）
     */
    private String shelfRanges;
    /**
     * 列（类型为1时特有）
     */
    private String shelfColumns;
    /**
     * 行（类型为1时特有）
     */
    private String shelfRows;

    /**
     * 号型id（类型为2时特有）
     */
    private String sizeId;

    /**
     * 号型名称（类型为2时特有）
     */
    private String sizeName;

    /**
     * 类型id（类型为2时特有）
     */
    private String typeId;

    /**
     * 类型名称（类型为2时特有）
     */
    private String typeName;

    /**
     * 申请人id
     */
    private String applyUserId;

    /**
     * 申请人
     */
    private String applyUser;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 审核状态（none,未接入审核流，working审批中，finished）

     */
    private String examineState;
    /**
     * 单据状态 ready待盘点，finished已完成，working盘点中
     */
    private String orderState;

    /**
     * 备注
     */
    private String note;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 排序字段
     */
    private String column;

    /**
     * 排序规则
     */
    private String order;
}
