package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum WarehouseAreaExceptionEnum implements IExceptionEnum {
    /**
     * 仓库地区信息不存在
     */
    WAREHOUSEAREA_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE , "地区信息不存在"),
    /**
     * 区域已存在
     */
    AREA_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"区域已经存在"),

    /**
     * 该区域不属于该仓库中
     */
    AREA_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE,"该区域不属于该仓库中")
    ;



    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    WarehouseAreaExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
