package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EqsBriefDto;
import com.junmp.jyzb.api.bean.dto.EqsSumDto;
import com.junmp.jyzb.api.bean.dto.InventoryDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.api.bean.req.InvExpireReq;
import com.junmp.jyzb.api.bean.vo.InventoryVo;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface InventoryMapper extends BaseMapper<Inventory> {

    List<Map<String, Object>> getLocationInventory(@Param("queryType")String queryType, @Param("idMsg")String idMsg);


    //根据单警柜统计装备信息
    boolean SetCabinetInventory(@Param("brokenNumberDays") Integer brokenNumberDays);

    //根据仓库统计装备信息
    boolean SetWarehouseInventory(@Param("brokenNumberDays") Integer brokenNumberDays);


    //根据货架id查询汇总信息(list)
    List<InventorySummary> getSumByShelf(String shelfId);

    //根据货架id查询汇总信息(page)
    IPage<InventorySummary> ShelfInventoryPage(Page<InventorySummary> page, String shelfId);

    //根据区域id查询汇总信息(list)
    List<InventorySummary> getSumByArea(String id);

    //根据区域id查询汇总信息(page)
    IPage<InventorySummary> AreaInventoryPage(Page<InventorySummary> page, String id);

    //通过单警柜箱门id获取箱门下的装备汇总信息(list)
    List<InventorySummary> getSumByCabinetBox(String id);

    //通过查询条件查询出装备数量报表
    List<EqsSumDto> GetListEquipment(InventoryReq req);

    //查询组织机构下面的装备信息
    List<InventoryVo> selectListByOrg(Long orgId);


    //通过单警柜箱门id获取箱门下的装备汇总信息(page)
    IPage<InventorySummary> EqsByCabinetBoxIdPage(Page<InventorySummary> page, String id);


     boolean insertInventorySummary(@Param("req") BatchEditingInvsReq req,@Param("brokenNumberDays")Integer brokenNumberDays);

     //判断epc是否存在
    List<String> checkEPCList(@Param("list") List<String> epcList);


    //根据条件查询满足条件的数据（用于快速移库修改装备仓库id）
    List<Inventory> selectEqsByItem(@Param("list") List<Object[]> searchCriteria);

    //根据epc获取装备信息
    List<InventoryDto> GetInvInfoByEpc(@Param("list") List<String> epcList);

    //通过组织机构id获取组织机构下的userIdlist
    List<InvExpireReq> selectUserListByOrgs(@Param("list") List<Long> uniqueOrgIDsList);

    List<Inventory> searchExpireEqs(@Param("list") List<Object[]> searchItem);
}