package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum InventoryExceptionEnum implements IExceptionEnum {
    INVENTORY_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"装备信息不存在")
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    InventoryExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
