package com.junmp.jyzb.utils;

import cn.hutool.core.util.ObjectUtil;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class DateTimeUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date getCurrentDateTime() {
        Date currentDate = new Date();
        String dateString = DATE_FORMAT.format(currentDate);
        try {
            return DATE_FORMAT.parse(dateString);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Map<String,Object>> timeSort(List<Map<String,Object>> allPoliceman) {
        Collections.sort(allPoliceman, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Date updateTime1 = (Date) o1.get("updateTime");
                Date updateTime2 = (Date) o2.get("updateTime");
                return updateTime2.compareTo(updateTime1);
            }
        });
        return allPoliceman;
    }

    //时间戳转时间(Long->String)
    public static String TimeLongToString(Long time){
        //时间戳转时间Date
        if (ObjectUtil.isNotNull(time)){
            Date updateTime = new Date(time*1000);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date= format.format(updateTime);
            return date;
        }else {
            return null;
        }
    }



    //String->Long(将string类型的时间转成时间戳)
    public static Long TimeStringToLong(String time){
        if (ObjectUtil.isNotNull(time) && !time.trim().isEmpty()){
            Date date = null;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = sdf.parse(time);
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
            long timestamp = date.getTime();
            return timestamp;
        }else {
            return null;
        }
    }
    //Date->Long (将date类型转为Long)
    public static Long TimeDateToLong(Date time){
        if (ObjectUtil.isNotNull(time)){
            long time1 = time.getTime();
            return time1;
        }else {
            return null;
        }
    }

    //String  -> Date(将string类型转成Date)
    public static Date TimeStringToDate(String time){
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            parse = format.parse(time);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse;
    }
    //将Date ->String （将Date转成String
    public static String TimeDateToString(Date time){
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format1 = format.format(time);
        return format1;
    }

    //获取当前时间年月日，时分秒都为0
    public static Date DateByDays(){
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = today.atStartOfDay().format(formatter);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date=new Date();
        try {
            date = sdf.parse(formattedDateTime);

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

}