package com.junmp.jyzb.api.bean.req;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class DestoryUnitReq extends BaseRequest {
    /**
     * 报废/销毁收物单位id
     */
    private String id;

    /**
     * 报废/销毁收物单位名称
     */
    @NotBlank(message = "报废/销毁收物单位不能为空",groups = {add.class,edit.class})
    private String name;

    /**
     * 报废/销毁收物单位短码
     */
    @NotBlank(message = "报废/销毁收物单位短码不能为空",groups = {add.class})

    /**
     * 简称
     */
    private String shortName;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 状态（1为启用，0为禁用）
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 批量删除报废/销毁单位id
     */
    private List<String> deleteList;
}
