package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class OrderMainReq extends BaseRequest {
    @NotBlank(message = "任务单id不能为空",groups = {detail.class})
    private String id;

    @NotBlank(message = "业务类型不能为空",groups = {edit.class})
    private String orderType;
    //实例流程id
    private String processId;

    private String bussinessType;

    private String orderCode;
    private String bussinessCode;

    private Long startOrgId;

    private String startOrgName;

    private Long endOrgId;

    private String endOrgName;
    private String supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;

    private String startOrgUserId;

    private String startOrgUserName;

    private String endOrgUserId;

    private String endOrgUserName;

    private String examineState;

    private BigDecimal price;

    private Integer inventoryQuantity;

    private Integer actualQuantity;

    private Integer updateQuantity;

    private Integer manualState;

    private String orderState;

    private String attachmentLocation;

    private String invList;
    private String typeName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    private String createUser;

    private String updateUser;
    //开始时间
    private String startTime;
    //结束时间
    private String endTime;

    private String typeId;

    //排序字段
    private String column;
    //排序规则
    private String order;

    private String isPrint;

    /**
     * 调拨类型（2支拨，1价拨），调拨出入库才有
     */
    private Integer allocateType;

    /**
     * 归还人，归还入库特有
     */
    private String returnUserId;

    /**
     * 移入仓库id
     */
    private String locationId;
    /**
     * 移入仓库名称
     */
    private String locationName;

    /**
     * 移入仓库id
     */
    private String removeLocationId;
    /**
     * 移入仓库名称
     */
    private String removeLocationName;

    private List<OrderDetailReq> detailList;

    private String receiveUserId;
    //发物单位，有可能是组织机构也有可能是供应商
    private String name;
    //计划子单json
    private String eqsJson;

    private Integer orderCurrentState;

    /**
     * 是否可见全部单子（1是，0否）
     */
    private Integer isAllVisible;

}


