package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("sys_trigger")
public class Trigger implements Serializable {
    /**
     * 供应商ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 触发器名称
     */
    @TableField(value = "trigger_name")
    private String triggerName;

    /**
     * 地址
     */
    @TableField(value = "action_class")
    private String actionClass;

    /**
     * 删除标识
     */
    @TableField(value = "del_flag")
    private String delFlag;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE, value = "update_time")
    private Date updateTime;



    /**
     * 更新人ID
     */
    @TableField(value = "update_user")
    private String updateUser;

}
