package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.ApplicationReq;
import com.junmp.jyzb.entity.Application;
import com.junmp.jyzb.service.ApplicationService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 应用管理模块
 */
@RestController
@Slf4j
@RequestMapping("/SoftUpdate")

@Api(tags = "软件应用管理模块")
public class ApplicationController {

    @Resource
    private ApplicationService applicationService;
    //获取应用信息的分页
    @PostMapping(path="/GetAllUpdateCfg",name="获取应用信息的分页#enable")
    @ApiOperation("获取应用信息的分页")
    public ApiRes<PageResult<Application>> GetAllUpdateCfg(@RequestBody ApplicationReq req){
        return ApiRes.success(applicationService.GetAllUpdateCfg(req));
    }

    //新增或者修改应用信息
    @PostMapping(path="/AddOrUpdateCfg",name="新增应用信息")
    @ApiOperation("新增应用信息")
    public ApiRes<String> AddOrUpdateCfg(@RequestBody @Validated(ValidationApi.add.class) ApplicationReq req){
        return ApiRes.success(applicationService.AddOrUpdateCfg(req));
    }


}
