package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class PolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {add.class, detail.class})
    private String id;

    @NotBlank(message = "姓名不能为空")
    private String name;

    private String cabinetId;

    private List<String> boxList;

    @NotNull(message = "组织机构id不能为空",groups = {add.class,page.class})
    private Long orgId;

    private Long departmentId;

    private String policeCode;

    @NotBlank(message = "性别不能为空")
    private String sex;

    private String faceInfo;

    //判断是否将系统账号和警员账号返回，如果是true，那么直接将警员返回，如果为空或者其他值，那么将系统账号和警员一起返回
    private String flag;
    //是否创建空数据，true则创建，false则不创建
    private Boolean isCreateNullDate;

    private String doorCode;

    //账号
    @NotBlank(message = "账号不能为空")
    private String account;

    //密码
    @NotBlank(message = "密码不能为空")
    private String password;

    private String photo;

    @NotBlank(message = "电话不能为空")
    private String phone;

    private Date createTime;

    private Long updateTime;

    private String idCard;

    private String updateUser;

    private Integer state;

    private String order;
    private String column;

    private List<String> roleCodeList;

    private Long userId;

    private static final long serialVersionUID = 1L;
}