package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.dto.ProcessOrderDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.req.BaseOrderReq;
import com.junmp.jyzb.api.bean.query.QueryOrderLogReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.entity.OrderLog;
import com.junmp.jyzb.service.OrderMainService;
import com.junmp.jyzb.service.HandoverService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Order")
@Api(tags = "业务模块")
public class OrderController {
    @Resource
    public OrderMainService orderMainService;

    @Resource
    public HandoverService handoverService;

    //通过工作流进行操作处理的
    @PostMapping("/AddOrder")
    @ApiOperation("新增任务单")
    public ApiRes<List<String>> addOrder(@RequestBody @Validated(ValidationApi.add.class) UpdateOrderReq req) {

        return ApiRes.success(orderMainService.AddOrder(req));
    }




    //内部处理，任务单状态直接设置成finished 添加到数据并且直接推送到消息队列中去
    @PostMapping("/AddFinishOrder")
    @ApiOperation("新增已完成的任务单")
    public ApiRes<String> AddFinishOrder(@RequestBody UpdateOrderReq req)  {

        return ApiRes.success(orderMainService.AddFinishOrder(req));
    }


    //修改任务单只允许工作流id为空的时候（视为草稿可以进行修改）
//    @PostMapping("/UpdateOrder")
//    @ApiOperation("修改任务单")
//    public ApiRes<Boolean>  updateOrder(@RequestBody @Validated(ValidationApi.edit.class) UpdateOrderReq req) {
//        return ApiRes.success(orderMainService.updateOrder(req));
//    }


    //查询任务列表(根据组织机构id)
    @PostMapping("/GetOrderPage")
    @ApiOperation("/查询任务列表")
    public ApiRes<PageResult<OrderMainDto>> getOrderPage(@RequestBody @Validated(ValidationApi.add.class)OrderMainReq req ){
        return ApiRes.success(orderMainService.getOrderPage(req));
    }

    @PostMapping("/GetDetailById")
    @ApiOperation("根据任务单id查看业务明细")
    public ApiRes<OrderDto> GetDetailById(@RequestBody @Validated(ValidationApi.detail.class) OrderMainReq req){
        return ApiRes.success(orderMainService.GetDetailById(req));
    }

    @PostMapping("/PushState")
    @ApiOperation("单据状态上报")
    public ApiRes<Boolean> PushState(@RequestBody @Validated(ValidationApi.delete.class) OrderUploadReq req){
        return ApiRes.success(orderMainService.PushState(req));
    }

    @PostMapping("/Accounting")
    @ApiOperation("记账")
    public ApiRes<Boolean> Accounting(@RequestBody @Validated(ValidationApi.delete.class) UpdateOrderReq req){
        return ApiRes.success(orderMainService.Accounting(req));
    }
    //记账完成之后往消息队列推送消息表示该单子已经完成结算


    @PostMapping("/ShowAccountingPage")
    @ApiOperation("查看记账列表")
    public ApiRes<PageResult<OrderLog>> ShowAccountingPage(@RequestBody QueryOrderLogReq req){
        return ApiRes.success(orderMainService.ShowAccountingPage(req));
    }


    //个人装备管理申请单
    @PostMapping("/AddPersonalEqsOrder")
    @ApiOperation("/新增个人装备申请单")
    public ApiRes<List<String>> AddPersonalEqsOrder(@RequestBody BaseOrderReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        return ApiRes.success(handoverService.EquipmentHandover(req));
    }

    //个人装备管理申请单的修改（移交申请）
    @PostMapping("/UpdatePersonalEqsOrder")
    @ApiOperation("修改个人装备申请单")
    public ApiRes<Boolean>  UpdatePersonalEqsOrder(@RequestBody BaseOrderReq req) {
        return ApiRes.success(handoverService.UpdatePersonalEqsOrder(req));
    }

    //单据打印
//    @PostMapping("OrderPrinting")
//    @ApiOperation("单据打印")
//    public ApiRes<Boolean> OrderPrinting(@RequestBody Object req){
//        try {
//            printerService.printObject(myObject); // 打印对象属性
//            return ResponseEntity.ok("Printing request sent to the printer");
//        } catch (PrintException e) {
//            e.printStackTrace();
//            return ResponseEntity.status(500).body("Error occurred while printing");
//        }
//    }

    //入库单导出
    @PostMapping("InOrderExport")
    @ApiOperation("入库单导出")
    public void InOrderExport(@RequestBody OrderMainReq req){
        orderMainService.InOrderExport(req);
    }

    //出库单导出
    @PostMapping("OutOrderExport")
    @ApiOperation("入库单导出")
    public void OutOrderExport(@RequestBody OrderMainReq req){
        orderMainService.OutOrderExport(req);
    }


    //根据流程id获取单据的装备信息
    @PostMapping("/GetByProcessId")
    @ApiOperation("根据流程id获取单据装备信息")
    public ApiRes<ProcessOrderDto> GetByProcessId(@RequestBody OrderMainReq req){
        return ApiRes.success(orderMainService.GetByProcessId(req));
    }
}
