package com.junmp.jyzb.controller;

import com.junmp.junmpProcess.dto.HandleDataDTO;
import com.junmp.jyzb.api.bean.query.SearchItemReq;
import com.junmp.jyzb.service.OrderCommonService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/OrderCommon")
@Api(tags = "业务通用模块")
public class OrderCommonController {
    //单子拒绝之后，需要修改当前单子的审批状态，修改为已驳回
    @Resource
    private OrderCommonService orderCommonService;
    @ApiOperation("审核不通过，修改单子状态")
    @PostMapping("/changeOrderExamineState")
    public ApiRes<Boolean> changeOrderExamineState(@RequestBody HandleDataDTO handleDataDTO){
        return ApiRes.success(orderCommonService.changeOrderExamineState(handleDataDTO));
    }

    @ApiOperation("判断库存数量是否足够，如果不足则返回装备信息")
    @PostMapping("/CheckSummaryStockNum")
    public ApiRes<String> CheckSummaryStockNum(@RequestBody SearchItemReq req){

        return ApiRes.success(orderCommonService.CheckSummaryStockNum(req));
    }

}
