package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.*;
import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.api.bean.req.EquipmentBindReq;
import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.entity.LogDetail;
import com.junmp.jyzb.entity.LogSummary;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;

@RestController
@Slf4j
@RequestMapping("/Inventory")
@Api(tags = "库存模块")
public class InventoryController {
    @Resource
    public InventoryService inventoryService;
    @Resource
    public InventorySummaryService inventorySummaryService;
    @Resource
    public MQProductService mqProductService;


    @GetMapping("/TestSum")
    @ApiOperation("根据组织机构查询库存信息")
    public ApiRes<Boolean> TestSum( ) {
        inventorySummaryService.MonthStartSum();
        return ApiRes.success();
    }

    @GetMapping("/testMQ")
    @ApiOperation("根据组织机构查询库存信息")
    public ApiRes<Boolean> testMQ( ) {
        String aa="";
        return ApiRes.success(mqProductService.sendMessage());
    }


    //填充汇总信息(根据base_inventory表中数据汇总同步)--第一次进行数据同步，适用于3.0初始化inventory_summary表
    //该方法只有插入语句，要注意inventory_summary表中没有数据，仅有结构，否则数据不准确
    @PostMapping("/SetInventoryMsg")
    @ApiOperation("填充汇总表信息")
    public ApiRes<Boolean> setInventoryMsg() {
        boolean result = inventoryService.setInventoryMsg();
        if (!result){
            return ApiRes.failure("汇总失败");
        }
        return ApiRes.success(result);
    }



    //装备绑定箱门
    @PostMapping("/EquipmentBind")
    @ApiOperation("装备绑定箱门")
    public ApiRes<Boolean> InventoryBind(@RequestBody @Validated(ValidationApi.edit.class) EquipmentBindReq req){
        return ApiRes.success(inventoryService.InventoryBind(req));
    }

    //手动修改仓库数量信息，修改的是base_warehouse中的个别字段（总数，总价,入库数，出库数），是通过inventory_summary进行统计的
    @PostMapping("/UpdateWarehouseInsNum")
    @ApiOperation("手动重置仓库库存数量信息")
    public ApiRes<Boolean> UpdateWarehouseInsNum(@RequestBody @Validated(ValidationApi.detail.class) WarehouseReq req){
        return ApiRes.success(inventoryService.UpdateWarehouseInsNum(req));
    }

    //手动修改单警柜数量信息，修改的是base_cabinet中的个别字段（总数，总价,入库数，出库数），是通过inventory_summary进行统计的
    @PostMapping("/UpdateCabinetInsNum")
    @ApiOperation("手动重置单警柜库存数量信息")
    public ApiRes<Boolean> UpdateCabinetInsNum(@RequestBody @Validated(ValidationApi.detail.class)CabinetReq req){
        return ApiRes.success(inventoryService.UpdateCabinetInsNum(req));
    }

    //根据Epc获取装备信息
    @PostMapping("/GetInvInfoByEpc")
    @ApiOperation("根据EPC列表获取装备信息")
    public ApiRes<List<InventoryDto>> GetInvInfoByEpc(@RequestBody InventoryReq req){
        return ApiRes.success(inventoryService.GetInvInfoByEpc(req));
    }



    //根据组织机构id/单警柜id/仓库id查询出库存的汇总信息(page)
    @PostMapping("/GetEquipmentInfo")
    @ApiOperation("根据条件查询库存汇总信息")
    public ApiRes<PageResult<InventorySummary>> getEquipmentInfo(@RequestBody InventorySumReq req) {
        return ApiRes.success(inventorySummaryService.getEquipmentInfo(req));
    }

    @PostMapping("/getOne")
    @ApiOperation("获取单个库存的数量")
    public ApiRes<InventorySummary> getOne(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.getOne(req));
    }



    //根据组织机构id/单警柜id/仓库id查询出库存汇总数量以及金额(和getEquipmentInfo同时调用，汇总出符合查询条件的装备)
    @PostMapping("/getTotalNumberAndPrice")
    @ApiOperation("查询总金额以及各个汇总数量")
    public ApiRes<List<InventorySummary>> getTotalNumberAndPrice(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.getTotalNumberAndPrice(req));
    }


    //根据装备id查询出装备的详细信息
    @PostMapping("/GetDetail")
    @ApiOperation("根据装备id查询装备明细信息")
    public ApiRes<InventoryDto> getInventoryDetail(@RequestBody @Validated(ValidationApi.detail.class) InventoryReq req) {
        return  ApiRes.success(inventoryService.getInventoryDetail(req));
    }

    //查询箱门（cabinetBox下）所有装备简要信息列表（传递cabinetBoxId）
    @PostMapping("/searchEqsByBoxId")
    @ApiOperation("查询某一箱门下的所有装备简要信息(list)")
    public ApiRes<List<EqsBriefDto>> searchEqsByBoxId(@RequestBody @Validated(ValidationApi.detail.class) CabinetBoxReq req){
        return ApiRes.success(inventoryService.searchEqsByBoxId(req));
    }

    //查询箱门（cabinetBox下）所有装备简要信息列表page（传递cabinetBoxId）
    @PostMapping("/searchEqsByBoxIdPage")
    @ApiOperation("查询某一箱门下的所有装备简要信息(page)")
    public ApiRes<PageResult<EqsBriefDto>> searchEqsByBoxIdPage(@RequestBody @Validated(ValidationApi.detail.class) CabinetBoxReq req){
        return ApiRes.success(inventoryService.searchEqsByBoxIdPage(req));
    }


    //查询单警柜箱门下的汇总信息（传递cabinetBoxId）
    @PostMapping("/EqsByCabinetBoxId")
    @ApiOperation("查询箱门下的汇总信息(list)")
    public ApiRes<List<InventorySummary>> EqsByCabinetBoxId(@RequestBody @Validated(ValidationApi.detail.class)CabinetBoxReq req){
        return ApiRes.success(inventoryService.EqsByCabinetBoxId(req));
    }

    //查询单警柜箱门下的汇总信息（传递cabinetBoxId）
    @PostMapping("/EqsByCabinetBoxIdPage")
    @ApiOperation("查询箱门下的汇总信息(page)")
    public ApiRes<PageResult<InventorySummary>> EqsByCabinetBoxIdPage(@RequestBody @Validated(ValidationApi.detail.class)CabinetBoxReq req){
        return ApiRes.success(inventoryService.EqsByCabinetBoxIdPage(req));
    }

    //根据货架id查询装备信息汇总(list)
    @PostMapping("/ShelfInventoryList")
    @ApiOperation("根据货架id查询装备信息汇总(list)")
    public ApiRes<List<InventorySummary>> ShelfInventoryList(@RequestBody @Validated(ValidationApi.edit.class) ShelfReq req){
        return ApiRes.success(inventoryService.ShelfInventoryList(req));
    }

    //根据货架id查询装备信息汇总 (page)
    @PostMapping("/ShelfInventoryPage")
    @ApiOperation("根据货架id查询装备信息汇总(page)")
    public ApiRes<PageResult<InventorySummary>> ShelfInventoryPage(@RequestBody @Validated(ValidationApi.edit.class) ShelfReq req){
        return ApiRes.success(inventoryService.ShelfInventoryPage(req));
    }

    @PostMapping("/ShelfInventoryDetail")
    @ApiOperation(("/通过货架id查询每件装备信息简要(list)"))
    public ApiRes<List<EqsBriefDto>> AreaInventoryDetail(@RequestBody @Validated(ValidationApi.list.class) InventoryReq req){
        return ApiRes.success(inventoryService.ShelfInventoryDetail(req));
    }

    @PostMapping("/ShelfEqsPage")
    @ApiOperation(("/通过货架id查询每件装备信息简要(page)"))
    public ApiRes<PageResult<EqsBriefDto>> ShelfInventoryPage(@RequestBody @Validated(ValidationApi.list.class) InventoryReq req){
        return ApiRes.success(inventoryService.ShelfInventoryPage(req));
    }

    //根据区域id查询装备信息汇总(list)
    @PostMapping("/AreaInventoryList")
    @ApiOperation("根据区域id查询装备信息汇总(list)")
    public ApiRes<List<InventorySummary>> AreaInventoryList(@RequestBody @Validated(ValidationApi.edit.class) WarehouseAreaReq req){
        return ApiRes.success(inventoryService.AreaInventoryList(req));
    }

    //根据区域id查询装备信息汇总(page)
    @PostMapping("/AreaInventoryPage")
    @ApiOperation("根据区域id查询装备信息汇总(page)")
    public ApiRes<PageResult<InventorySummary>> AreaInventoryPage(@RequestBody @Validated(ValidationApi.edit.class) WarehouseAreaReq req){
        return ApiRes.success(inventoryService.AreaInventoryPage(req));
    }

    //导出,通过传递组织机构id，将该组织机构下的所有装备信息进行导出
    @PostMapping("/ExportInventoryExcel")
    @ApiOperation("组织机构装备导出")
    public void ExportInventoryExcel(@RequestBody @Validated(ValidationApi.export.class) InventoryReq req) {
        inventoryService.ExportInventoryExcel(req);
    }


    //根据条件（组织机构，装备类型id，装备型号id，装备型号名称）查询装备总数，在库数，出库数，单警柜在库数，单警柜出库数，报废数
    //查询装备数量报表
    @PostMapping("/GetListEquipment")
    @ApiOperation("根据条件查询数量汇总")
    public ApiRes<List<EqsSumDto>> GetListEquipment(@RequestBody InventoryReq req){
        return ApiRes.success(inventoryService.GetListEquipment(req));
    }

    //根据条件查询仓库/单警柜下的所有装备信息
    @PostMapping("/GetDetailByTerms")
    @ApiOperation("根据条件查询仓库/单警柜下的所有装备信息")
    public ApiRes<PageResult<InventoryDto>> GetDetailByTerms(@RequestBody @Validated(ValidationApi.export.class) InventoryReq req){
        return ApiRes.success(inventoryService.GetDetailByTerms(req));
    }

    /**
     * 根据查询条件，查询出库存中的装备信息汇总，选择装备时使用该接口进行查询填写
     */
    //根据组织机构orgId查询出该组织机构下的仓库id
    //根据仓库id和orgId查询出库存中存在的装备typeId
    //根据仓库id，orgId,type_id 查询出装备号型sizeId
    //根据仓库id，orgId，typeId，sizeId查询出单价和对应的数量
    @PostMapping("/GetInventorySumInfo")
    @ApiOperation("查询出库存中的装备信息")
    public ApiRes<List<InventorySumDto>> GetInventorySumInfo(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.GetInventorySumInfo(req));
    }

    //批量信息修改（修改质保期，维保期，购入单价，生产日期，存放货架，货架位置）
    @PostMapping("/BatchEditingInvsInfo")
    @ApiOperation("批量信息修改")
    public ApiRes<Boolean> BatchEditingInvsInfo(@RequestBody BatchEditingInvsReq req){
        return ApiRes.success(inventoryService.BatchEditingInvsInfo(req));
    }


    //首页上的装备统计数量
    @PostMapping("/EquipmentStatistics")
    @ApiOperation("装备数量数据统计")
    public ApiRes<List<InventorySummary>> EquipmentStatistics(@RequestBody InventorySumReq req){

        return ApiRes.success(inventorySummaryService.EquipmentStatistics(req));
    }

    //判断epc是否存在
    @PostMapping("/checkEPCList")
    @ApiOperation("判断epc是否存在")
    public ApiRes<List<String>> checkEPCList(@RequestBody EpcCheckReq req){
        return ApiRes.success(inventoryService.checkEPCList(req));
    }

    //调用存储过程将汇总信息进行插入
    @PostMapping("/insertToSummary")
    @ApiOperation("将汇总信息进行插入更新")
    public ApiRes<Boolean> insertToSummary(){
        return ApiRes.success(inventorySummaryService.insertToSummary());
    }

    @PostMapping("/selectTotalNum")
    @ApiOperation("根据组织机构和装备查询库存")
    public ApiRes<List<InventorySumDto>> selectTotalNum(@RequestBody SelectTotalNumReq req){
        return ApiRes.success(inventorySummaryService.selectTotalNum(req));
    }

    @PostMapping("/selectSumByItems")
    public ApiRes<List<InventorySummary>> selectSumByItems(@RequestBody SelectTotalNumReq req){
        return ApiRes.success(inventorySummaryService.selectSumByItems(req));
    }

}
