package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.BusFormDto;
import com.junmp.jyzb.api.bean.query.QueryBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.service.BusFormService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 业务单据管理模块（只针对业务单据，不包含任何出入库单据）
 */
@RestController
@Slf4j
@RequestMapping("/BussinessManage")
@Api(tags = "业务管理模块")
public class BussinessController {
    @Resource
    public BusFormService busFormService;


    //创建业务单
    @PostMapping("/AddBussinessOrder")
    @ApiOperation("创建业务单")
    public ApiRes<String> AddBussinessOrder(@RequestBody @Validated(ValidationApi.add.class) UpdateBusFormReq req){

        return ApiRes.success(busFormService.AddBussinessOrder(req));
    }


    //查看业务单（可以条件查询）
    @PostMapping("/showBussinessOrder")
    @ApiOperation("查看业务单")
    public ApiRes<PageResult<BusFormDto>> showBussinessOrder(@RequestBody QueryBusFormReq req){
        return ApiRes.success(busFormService.showBussinessOrder(req));
    }

    //根据调拨单，一键生成采购单
//    @PostMapping("/GeneratePurchaseQuickly")
//    @ApiOperation("快速生成采购单")
//    public ApiRes<List<GeneratePurchaseQuicklyDto>> GeneratePurchaseQuickly(@RequestBody GeneratePurchaseQuicklyReq req){
//        return ApiRes.success(busFormService.GeneratePurchaseQuickly(req));
//    }


}
