package com.junmp.jyzb.api.bean.query;


import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class InventorySumReq extends BaseRequest {

    private String id;
    /**
     * 组织机构
     */
    private String orgId;

    /**
     * 组织机构名称
     */
    private String orgName;
    /**
     * 位置ID（仓库id或者单警柜id）
     */
    private String locationId;
    /**
     * 位置信息
     */
    private String locationName;

    /**
     * 位置类型（0仓库，1单警柜）
     */
    private String locationType;
    /**
     * 类型ID
     */
    private String typeId;
    /**
     * 类型IDs
     */
    public List<String>  typeIds;
    /**
     * 类型名称
     */
    private String typeName;
    /**
     * 号型ID
     */
    private String sizeId;
    /**
     * 号型名称
     */
    private String sizeName;
    /**
     * 号型名称集合
     */
    private List<String> sizeNames;
    /**
     * 排序规则
     */
    private String order;

    /**
     * 排序列
     */
    private String column;

    /**
     * 装备总数
     */
    private String number;
    /**
     * 在库数
     */
    private String stockNumber;
    /**
     * 出库数
     */
    private String outboundNumber;
    /**
     * 过质保数
     */
    private String expireNumber;
    /**
     * 报废数
     */
    private String brokenNumber;
    /**
     * 单价
     */
    private String unitPrice;
    /**
     * 总金额
     */
    private String price;

}
