package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * 装备异常信息，包括了size和type
 */
@Getter
public enum EquipmentExceptionEnum implements IExceptionEnum {

    /**
     * 装备类别不存在
     */
    EQUIPMENT_TYPE_NOT_EXIST(CommonConstant.DEFAULT_CORE_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "装备或类别不存在"),

    /**
     * 有多关联装备，无法删除
     */
    EQUIPMENT_CHILDREN_EXIST(CommonConstant.DEFAULT_CORE_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 13, "有多关联装备，无法删除"),

    /**
     * 装备不存在
     */
    SUPPLIER_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 13, "{}"),

    /**
     * 装备名称重复
     */
    EQUIPMENT_NAME_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"装备名称重复"),
    /**
     * 装备名称和编号重复
     */
    EQUIPMENT_NAME_CODE_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"装备名称和编号重复"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;


    EquipmentExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
