package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.Repository.SizeRepository;
import com.junmp.jyzb.api.bean.dto.EquipmentSizeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentSizeReq;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentSizeReq;
import com.junmp.jyzb.api.exception.enums.EquipmentExceptionEnum;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentSizeMapper;

import java.util.*;

@Service
public class EquipmentSizeServiceImpl extends ServiceImpl<EquipmentSizeMapper, EquipmentSize> implements EquipmentSizeService {

    @Resource
    private EquipmentSizeMapper equipmentSizeMapper;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;

    @Resource
    private EquipmentTypeService equipmentTypeService;

    @Autowired
    private SizeRepository sizeRepository;

    @Override
    public Object addEs() {
        QueryEquipmentTypeReq req =new QueryEquipmentTypeReq();
        req.setType(0);
        List<EquipmentSize> esDto=this.list();
        return sizeRepository.saveAll(esDto);
    }
    @Override
    public String addSize(UpdateEquipmentSizeReq req) {
        //判断输入的typeId是否存在，如果不存在抛出异常
        EquipmentType one = equipmentTypeService.getById(req.getTypeId());
        if (one==null){
            throw new ServiceException(EquipmentExceptionEnum.EQUIPMENT_TYPE_NOT_EXIST);
        }
        //判断同一个typeId下面是否有相同的name和code，如果有则添加失败
        List<EquipmentSize> list = list(new LambdaQueryWrapper<EquipmentSize>()
                .eq(EquipmentSize::getCode, req.getCode())
                .eq(EquipmentSize::getName, req.getName())
                .eq(EquipmentSize::getTypeId,req.getTypeId()));
        if (list.size()>0){
            throw new ServiceException(EquipmentExceptionEnum.EQUIPMENT_NAME_CODE_EXIST);
        }
        EquipmentSize size = new EquipmentSize();
        String sizeID=UUID.randomUUID().toString();
        BeanPlusUtil.copyProperties(req, size);
        size.setId(sizeID);
        this.save(size);
        sizeRepository.save(size);
        return sizeID;
    }

    @Override
    public EquipmentSize getOneSize(QueryEquipmentSizeReq req) {
        return this.getById(req);
    }

    @Override
    public Boolean deleteSize(UpdateEquipmentSizeReq req) {
        sizeRepository.deleteById(Long.valueOf(req.getId()));
        return this.removeById(req.getId());

    }

    @Override
    public Boolean updateSize(UpdateEquipmentSizeReq req) {
        //判断输入的typeId是否存在，如果不存在抛出异常
        EquipmentType one = equipmentTypeService.getById(req.getTypeId());
        if (one==null){
            throw new ServiceException(EquipmentExceptionEnum.EQUIPMENT_TYPE_NOT_EXIST);
        }
        EquipmentSize size = this.querySize(req);
        BeanPlusUtil.copyProperties(req, size);
        sizeRepository.save(size);
        return this.updateById(size);
    }

    @Override
    public Boolean changeSizeState(UpdateEquipmentSizeReq req) {
        EquipmentSize size = this.querySize(req);
        size.setState(Integer.valueOf(req.getState()));
        sizeRepository.save(size);
        return this.updateById(size);
    }

    @Override
    public List<EquipmentSizeDto> getAllSize(QueryEquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = createWrapper(req);
        List<EquipmentSize> es = this.list(wrapper);


        List<EquipmentSizeDto> dtoList = new ArrayList<>();

        // 将 EquipmentSize 对象转换为 EquipmentSizeDto 对象并添加到 dtoList 中
        for (EquipmentSize equipmentSize : es) {
            EquipmentSizeDto dto = new EquipmentSizeDto();
            BeanPlusUtil.copyProperties(equipmentSize, dto);
            dtoList.add(dto);
        }
        return dtoList;
    }
    @Override
    public PageResult<EquipmentSizeDto> getSizePages(QueryEquipmentSizeReq req) {
        Page<EquipmentSizeDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
       List<EquipmentSizeDto> voList= equipmentSizeMapper.getSizePage(req,page);
        page.setRecords(voList);
        return PageResultFactory.createPageResult(page);


    }

    //根据typeId返回号型名称
    @Override
    public List<String> getByTypeIds(QueryEquipmentSizeReq req) {
        List<String> typeIdsList = req.getTypeIdsList();
        List<String> idsList = selectByTypeIds(typeIdsList);
        return equipmentSizeMapper.searchByTypeIds(idsList);
    }

    public List<String> selectByTypeIds(List<String> typeIdsList){
        List<String> list1=new ArrayList<>();
        List<String> list2=new ArrayList<>();
        List<String> list3=new ArrayList<>();
        List<String> list4=new ArrayList<>();
        List<EquipmentType> list = equipmentTypeService.list(new LambdaQueryWrapper<EquipmentType>().in(EquipmentType::getId, typeIdsList));

        for (EquipmentType equipmentType:list) {
            //根据parentId判断他在第几层
            String parentIds = equipmentType.getParentIds();
            List<String> parentIdsList = Arrays.asList(parentIds.split(","));
            //判断parentIdsList的长度，将他放在第几层的位置
            if (parentIdsList.size()==1){
                list1.add(equipmentType.getId());
            } else if (parentIdsList.size()==2) {
                list2.add(equipmentType.getId());
            } else if (parentIdsList.size()==3) {
                list3.add(equipmentType.getId());
            }else {
                list4.add(equipmentType.getId());
            }

        }
        return equipmentTypeMapper.selectByItems(list1,list2,list3,list4);
    }

    private EquipmentSize querySize(UpdateEquipmentSizeReq req) {
        EquipmentSize app = this.getById(req.getId());

        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.SIZE_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<EquipmentSize> createWrapper(QueryEquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeId()), EquipmentSize::getTypeId, req.getTypeId());
        //根据名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), EquipmentSize::getName, req.getName());

        wrapper.orderByDesc(EquipmentSize::getCreateTime);
        return wrapper;
    }
}