package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.ESOrgDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.UpdateOrgReq;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/PubOrg")
@Api(tags = "组织机构模块")
public class PubOrgController {
    @Resource
    public PubOrgService pubOrgService;

    @GetMapping("/SetOrgParentIds")
    @ApiOperation("填充组织机构的parent_ids字段")
    public ResponseResult setOrgParentIds() {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setOrgParentIds();
        return returnMsg;
    }

    @PostMapping("/SetDName")
    @ApiOperation("填充组织机构简称到数据库")
    public ResponseResult setShortName(@RequestBody Map<String, Object> orgId) {
        ResponseResult returnMsg = pubOrgService.setShortName(orgId);
        return returnMsg;
    }

    @PostMapping("/GetOrgList")
    @ApiOperation("查询组织机构列表")
    public ApiRes<List<OrgDto>> getOrgList(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getOrgList(req));
    }
    @PostMapping("/GetCurrentList")
    @ApiOperation("根据当前组织机构列表查询")
    public ApiRes<OrgDto> GetCurrentList(@RequestBody @Validated(ValidationApi.detail.class) QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getOrgHierarchy(req));
    }
    @PostMapping("/GetCurrentESList")
    @ApiOperation("根据当前组织机构列表ES查询")
    public ApiRes<ESOrgDto> GetCurrentESList(@RequestBody  QueryOrgReq req) throws IOException {
        return ApiRes.success(pubOrgService.getOrgTreeByEs(req));
    }
    @PostMapping("/ChangeOrgState")
    @ApiOperation("改变组织机构状态信息")
    public ApiRes<Boolean> changeOrgState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateOrgReq req) {
        return ApiRes.success(pubOrgService.ChangeState(req));
    }
    @PostMapping("/GetLowOrg")
    @ApiOperation("根据组织机构查询下一级信息")
    public ApiRes<List<OrgDto>> getLowOrg(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getLowOrg(req)) ;
    }
}
