package com.junmp.jyzb.controller.ES;

import com.junmp.jyzb.Repository.BlogRepository;
import com.junmp.jyzb.entity.ES.Blog;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.service.PubOrgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Api(tags = "增删改查（文档）")
@RestController
@Slf4j
@RequestMapping("crud")
public class CrudController {
    @Autowired
    private BlogRepository blogRepository;
    @Resource
    public EquipmentTypeService equipmentTypeService;
    @Resource
    public EquipmentSizeService equipmentSizeService;
    @Resource
    public PubOrgService pubOrgService;
    @ApiOperation("测试")
    @PostMapping("testDocument")
    public Object testDocument() {
       return equipmentTypeService.addEs();
    }
    @ApiOperation("测试组织机构")
    @PostMapping("testOrgDocument")
    public Object testOrgDocument() {
        return pubOrgService.AddToEs();
    }

    @ApiOperation("一键初始化ES")
    @PostMapping("UpdateES")
    public Object UpdateES() {
        pubOrgService.AddToEs();
        equipmentTypeService.addEs();
        equipmentSizeService.addEs();
        return true;
    }
    @ApiOperation("添加单个文档")
    @PostMapping("addDocument")
    public Blog addDocument() {
        Long id = 1L;
        Blog blog = new Blog();
        blog.setBlogId(id);
        blog.setTitle("巡特警" + id);
        blog.setContent("巡特警手铐" + id);
        blog.setAuthor("Tony");
        blog.setCategory("ElasticSearch");
        blog.setCreateTime(new Date());
        blog.setStatus(1);
        blog.setSerialNum(id.toString());

        Long id1 = 2L;
        Blog blog1 = new Blog();
        blog1.setBlogId(id1);
        blog1.setTitle("巡特警" + id1);
        blog1.setContent("巡特警盾牌" + id1);
        blog1.setAuthor("Tony");
        blog1.setCategory("ElasticSearch");
        blog1.setCreateTime(new Date());
        blog1.setStatus(1);
        blog1.setSerialNum(id1.toString());
        blogRepository.save(blog1);

        return blogRepository.save(blog);
    }

    @ApiOperation("添加多个文档")
    @PostMapping("addDocuments")
    public Object addDocuments(Integer count) {
        List<Blog> blogs = new ArrayList<>();
        for (int i = 1; i <= count; i++) {
            Long id = (long)i;
            Blog blog = new Blog();
            blog.setBlogId(id);
            blog.setTitle("Spring Data ElasticSearch学习教程" + id);
            blog.setContent("这是添加单个文档的实例" + id);
            blog.setAuthor("Tony");
            blog.setCategory("ElasticSearch");
            blog.setCreateTime(new Date());
            blog.setStatus(1);
            blog.setSerialNum(id.toString());
            blogs.add(blog);
        }

        return blogRepository.saveAll(blogs);
    }

    /**
     * 跟新增是同一个方法。若id已存在，则修改。
     * 无法只修改某个字段，只能覆盖所有字段。若某个字段没有值，则会写入null。
     * @return 成功写入的数据
     */
    @ApiOperation("修改单个文档")
    @PostMapping("editDocument")
    public Blog editDocument() {
        Long id = 1L;
        Blog blog = new Blog();
        blog.setBlogId(id);
        blog.setTitle("Spring Data ElasticSearch学习教程" + id);
        blog.setContent("这是修改单个文档的实例" + id);
        // blog.setAuthor("Tony");
        // blog.setCategory("ElasticSearch");
        // blog.setCreateTime(new Date());
        // blog.setStatus(1);
        // blog.setSerialNum(id.toString());

        return blogRepository.save(blog);
    }

    @ApiOperation("查找单个文档")
    @GetMapping("findById")
    public Blog findById(Long id) {

        return blogRepository.findById(id).get();
    }

    @ApiOperation("删除单个文档")
    @PostMapping("deleteDocument")
    public String deleteDocument(Long id) {
        blogRepository.deleteById(id);
        return "success";
    }

    @ApiOperation("删除所有文档")
    @PostMapping("deleteDocumentAll")
    public String deleteDocumentAll() {
        blogRepository.deleteAll();
        return "success";
    }
}
