package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.UpdateCabinetBoxReq;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/CabinetBox")
@Api(tags = "箱门信息模块")
public class CabinetBoxController {
    @Resource
    private CabinetBoxService cabinetBoxService;
    //添加箱门信息
    @PostMapping("/AddBoxInfo")
    @ApiOperation("添加箱门信息")
    public ApiRes<String> AddBoxInfo(@RequestBody @Validated(ValidationApi.add.class) UpdateCabinetBoxReq req){
        return ApiRes.success(cabinetBoxService.AddBoxInfo(req));
    }
}
