package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class OrderDetailReq extends BaseRequest {

    private Long id;

    @NotBlank(message = "任务单id不能为空",groups = {detail.class})
    private String orderId;

    private String type;

    private String typeId;

    private String typeName;

    private String sizeId;

    private String sizeName;

    private String supplierId;

    private String supplierName;

    private Integer planNum;

    private Integer actualNum;


    private BigDecimal price;

    private String orderType;

    private Date createTime;

    private Date updateTime;

    private String createUser;

    private String updateUser;

    private String warehouseId;

    private String warehouseName;

    /**
     * 修改后数量(记账数量)
     */
    private Integer modifyQuantity;

}
