package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.WarehouseAreaReq;
import com.junmp.jyzb.api.bean.query.ProductReq;
import com.junmp.jyzb.api.bean.query.WarehouseReq;
import com.junmp.jyzb.api.exception.enums.WarehouseExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
@Slf4j
public class WarehouseServiceImpl extends ServiceImpl<WarehouseMapper,Warehouse> implements WarehouseService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private WarehouseMapper warehouseMapper;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private ShelfMapper shelfMapper;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private WarehouseAreaMapper areaMapper;

    private static final String REDIS_WAREHOUSE = "Warehouse_";


    @Override
    public boolean addWarehouse(WarehouseReq req) {
        Warehouse warehouse = new Warehouse();
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.save(warehouse);
    }

    @Override
    public Warehouse getOneWarehouse(WarehouseReq req) {

        Warehouse warehouseMsg=this.getById(req.getId());
        if (warehouseMsg == null) {
            return null;
        }
        // 填充其他关联信息的字段和对象引用
        return warehouseMsg;
    }


    @Override
    public boolean deleteWarehouse(WarehouseReq req) {
        this.removeById(req.getId());
        return true;
    }

    @Override
    public boolean updateWarehouse(WarehouseReq req) {
        Warehouse warehouse = this.queryWarehouse(req);
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.updateById(warehouse);
    }


    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }

    @Override
    public List<Warehouse> getAllWarehouse(WarehouseReq msg) {
        List<Warehouse> allWarehouse=new ArrayList<>();

        //如果组织机构是浙江省公安厅
        if (msg.getOrgId().equals(1369509498032808905l) && msg.getIncludeLowerLevel().equals("true")){
            allWarehouse = this.list();
            return allWarehouse;
        }

        //获取组织机构Id
        List<String> allOrgId =getAllOrgId(msg);

        //根据获取的组织机构查询警员信息
        allWarehouse = getAllWarehouseByOrg(allOrgId);

        return allWarehouse;
    }


    private List<String> getAllOrgId(WarehouseReq msg) {
        List<String> allOrg = new ArrayList<>();
        if (msg.getIncludeLowerLevel().equals("false")){
            allOrg.add(msg.getOrgId().toString());
        }else if(msg.getIncludeLowerLevel().equals("true")){
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(msg.getOrgId().toString());
        }
        return allOrg;
    }

    private List<Warehouse> getAllWarehouseByOrg(List<String> allOrgId) {
        List<Warehouse> allWarehouse = new ArrayList<>();

        LambdaQueryWrapper<Warehouse> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(Warehouse::getOrgIdInt, allOrgId);

        allWarehouse = warehouseMapper.selectList(queryWrapper);
        return allWarehouse;
    }



    @Override
    public boolean changeWarehouseState(WarehouseReq req) {
        Warehouse warehouse = this.queryWarehouse(req);
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.updateById(warehouse);
    }

    @Override
    public ResponseResult setWarehouseInventory(Map<String, Object> msg) {
        String id;
        if (msg.containsKey("locationId") && msg.get("locationId")!=""){
            id = msg.get("locationId").toString();
        }else {
            id = null;
        }
        //统计仓库 装备总数
        warehouseMapper.setWarehouseSumInventory(id);
        //统计仓库 装备在库总数
        warehouseMapper.setWarehouseInSumInventory(id);
        //统计仓库 装备出库总数
        warehouseMapper.setWarehouseOutSumInventory(id);
        //统计仓库 装备出库总数
        warehouseMapper.setWarehousePriceInventory(id);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    private Warehouse queryWarehouse(WarehouseReq req) {
        Warehouse app = this.getById(req.getId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(WarehouseExceptionEnum.WAREHOUSE_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<Product> createWrapper(ProductReq req) {
        LambdaQueryWrapper<Product> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getProductCode()), Product::getProductCode, req.getProductCode());
        //根据企业名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), Product::getName, req.getName());
        wrapper.orderByDesc(Product::getUpdateTime);
        return wrapper;
    }
}
