package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.dto.OrgTreeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.OrgUpdateReq;
import com.junmp.jyzb.api.bean.query.ProductTagReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.entity.ProductTag;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.RedisUtils;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.PubOrgMapper;
import com.junmp.jyzb.service.PubOrgService;

import java.util.*;


@Service
public class PubOrgServiceImpl extends ServiceImpl<PubOrgMapper, PubOrg>  implements PubOrgService{

    @Resource
    private PubOrgMapper pubOrgMapper;


    @Autowired
    private RedisUtils redisUtils;


    //例：传入abc,a ==>bc 删掉开头的字符串，不是就不删除
    public static String removePrefix(String name, String deleteName) {
        if (name.startsWith(deleteName)) {
            return name.substring(deleteName.length());
        } else {
            return name;
        }
    }



    @Override
    public List<String> getLowerOrg(String orgId) {
        //构建 Redis 缓存�
        String redisKey = "getLowerOrg";

        // �Redis 中获取数�
        List<PubOrg> cachedData = redisUtils.findCachedData(redisKey);
        List<PubOrg> menuList = new ArrayList<>();
        if (cachedData!=null){
            menuList = cachedData;
        }else {
            menuList = pubOrgMapper.selectAllOrg();
            redisUtils.set(redisKey, menuList);
        }

        List<String> resultList = new ArrayList<>();  // 存储最终的菜单树结果
        Map<String, List<String>> childrenMap = new HashMap<>();  // 存储每个菜单项的子菜单映射

        resultList.add(orgId); //将自己加入到返回的List中

        // 构建子菜单映射表
        for (PubOrg menu : menuList) {
            String org = menu.getOrgId().toString();

            if (!childrenMap.containsKey(menu.getOrgParentId().toString())) {  // 如果父菜单还不存在于映射表中
                childrenMap.put(menu.getOrgParentId().toString(), new ArrayList<>());  // 创建一个新的子菜单列表
            }
            childrenMap.get(menu.getOrgParentId().toString()).add(org);  // 将当前菜单项放入对应的子菜单列表中
        }

        Long orgInfo = Long.valueOf(orgId);//获取输入的组织机构id信息
        //Long orgInfo = new BigInteger(orgId);  // 获取顶级菜单的标识符

        // 获取顶级菜单
        List<String> topMenus = childrenMap.get(orgId);

        // 迭代构建菜单树
        if (topMenus != null) {

            for (String topMenu : topMenus) {
                Stack<String> stack = new Stack<>();  // 使用栈结构辅助构建菜单树
                stack.push(topMenu);  // 将当前顶级菜单项放入栈中

                while (!stack.isEmpty()) {
                    String currentMenu = stack.pop(); // 取出队首的当前菜单项
                    //Long currentMenuId = currentMenu;  // 获取当前菜单项的标识符

                    if (childrenMap.containsKey(currentMenu)) {  // 如果当前菜单项有子菜单
                        List<String> children = childrenMap.get(currentMenu);  // 获取子菜单列表

                        for (int i = children.size() - 1; i >= 0; i--) {
                            stack.push(children.get(i));
                        }
                    }

                    resultList.add(currentMenu);  // 将已经处理完的当前菜单项添加到结果列表中
                }
            }

        }

        return resultList;
    }


    @Override
    public ResponseResult setOrgParentIds() {
        //清空parent_ids字段
        pubOrgMapper.wipeParentIdsData();
        //更新parent_ids字段
        pubOrgMapper.setOrgParentIds();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult setShortName(Map<String, Object> orgId) {

        List<PubOrg> menuList = pubOrgMapper.selectAllOrg();
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (PubOrg menu : menuList) {
            if (menu.getOrgParentId().toString().equals((orgId.get("orgId")))) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getOrgId());
                map.put("parentId", menu.getOrgParentId());
                //去掉前缀
                String name1 = menu.getOrgName(); //name1 ,获得“浙江省公安厅”
                //List<String> name2 = null;
                List<String> name2 = new ArrayList<>();
                //name3为固定字段
                List<String> name3 = new ArrayList<>();
                name3.add("公安局");
                name3.add("公安");
                name3.add("分局");

                if (menu.getOrgName().length()>3 && name2.size() <2 && (menu.getOrgName().charAt(2)=='省' ||menu.getOrgName().charAt(2)=='市')){
                    String nameHistory = menu.getOrgName().substring(0,3); //name2 ,获得“浙江省”
                    name2.add(nameHistory);
                    name2.add(" ");
                    name2.add(" ");

                }

                if (menu.getOrgName().length()>3 && (menu.getOrgName().charAt(2)=='区')){
                    name2.remove(2);
                    String nameHistory = menu.getOrgName().substring(0,3);
                    name2.add(2,nameHistory);
                }

                map.put("orgName", name1);
                List<Map<String, Object>> children = getChildMenus(menu.getOrgId(),menuList,name1,name2,name3);//name为要删掉的前缀
                if (!children.isEmpty()) {
                    map.put("children", children);
                    for (Map<String,Object> msg:children){
                        Long id = (Long) msg.get("id");
                        String orgName = msg.get("orgName").toString();
//                        pubOrgMapper.setMsg(id,orgName);
                    }
                }
                //map.put("children", getChildMenus(menu.getOrgId(),menuList,name1,name2,name3));
                resultList.add(map);


            }
        }

        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",resultList);
    }

    private List<Map<String, Object>> getChildMenus(Long parentId, List<PubOrg> menuList,String deleteName1,List<String> deleteName2,List<String> deleteName3) {
        List<Map<String, Object>> childList = new ArrayList<>();
        for (PubOrg menu : menuList) {
            //if (menu.getParentId() != null && menu.getParentId().equals(parentId)) {
            if (menu.getOrgParentId().toString().equals(parentId.toString())) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getOrgId());
                map.put("parentId", menu.getOrgParentId());
                //去掉前缀
                String name1 = menu.getOrgName();
                List<String> name2 = new ArrayList<>();
                name2 = deleteName2;
                String result = removePrefix(name1, deleteName1);
                //遍历name2删掉前缀
                for (String nameMsg:name2){
                    result = removePrefix(result, nameMsg);
                    for (String name3:deleteName3){
                        result = removePrefix(result, name3);
                    }
                }
                map.put("orgName", result);
                if (result.length()>3 && (result.charAt(2)=='省' ||result.charAt(2)=='市')){
                    name2.remove(1);
                    String nameHistory = result.substring(0,3); //获得“绍兴市”
                    name2.add(1,nameHistory);
                }

                if (result.length()>3 && (result.charAt(2)=='区' ||result.charAt(2)=='县')){
                    name2.remove(2);
                    String nameHistory = result.substring(0,3);
                    name2.add(2,nameHistory);
                }

                List<Map<String, Object>> children = getChildMenus(menu.getOrgId(), menuList,name1,name2,deleteName3);
                if (!children.isEmpty()) {
                    map.put("children", children);
                }
                childList.add(map);
            }
        }
        return childList;
    }


    public List<OrgDto> getLowOrg(QueryOrgReq req){
        if (ObjectUtil.isEmpty(req.getParentId())) {
            req.setParentId(req.getOrgId());
        }

        LambdaQueryWrapper<PubOrg> wp= this.createWrapper(req);
        List<PubOrg> list = this.list(wp);
        List<OrgDto> orgs=new ArrayList<>();
        Comparator<PubOrg> orgComparator = (org1, org2) -> {
            String orgCode1 = org1.getOrgCode();
            String orgCode2 = org2.getOrgCode();

            // 判断是否包含字母
            boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z]+.*");
            boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z]+.*");

            // 如果其中一个包含字母，则将其放到排序的最后
            if (hasLetter1 && !hasLetter2) {
                return 1; // orgCode1包含字母，orgCode2不包含字母，orgCode1排在orgCode2后面
            } else if (!hasLetter1 && hasLetter2) {
                return -1; // orgCode1不包含字母，orgCode2包含字母，orgCode1排在orgCode2前面
            }

            // 如果两个orgCode都不含有字母，则按照每两位进行排序
            String[] orgCodeArray1 = orgCode1.split("(?<=\\G..)");
            String[] orgCodeArray2 = orgCode2.split("(?<=\\G..)");

            // 从最后一组（即最后两位）开始比较数字大小
            int index1 = orgCodeArray1.length - 1;
            int index2 = orgCodeArray2.length - 1;
            while (index1 >= 0 && index2 >= 0) {
                String codeValue1 = orgCodeArray1[index1];
                String codeValue2 = orgCodeArray2[index2];

                // 判断是否可以转换为整数，如果不能，则说明包含字母，直接返回结果
                try {
                    int intValue1 = Integer.parseInt(codeValue1, 10);
                    int intValue2 = Integer.parseInt(codeValue2, 10);
                    int compareResult = Integer.compare(intValue1, intValue2);
                    if (compareResult != 0) {
                        return compareResult;
                    }
                } catch (NumberFormatException e) {
                    // orgCode包含字母，直接返回结果
                    return codeValue1.compareTo(codeValue2);
                }

                index1--;
                index2--;
            }

            // 如果orgCode长度不同，那么较长的orgCode排在后面
            return Integer.compare(orgCodeArray1.length, orgCodeArray2.length);
        };
        Collections.sort(list, orgComparator);

        list.forEach(p->{
            OrgDto org=new OrgDto();
            BeanPlusUtil.copyProperties(p, org);

            orgs.add(org);
        });
        return orgs;
    }

    public List<OrgTreeDto> getOrgList(QueryOrgReq req) {

        String selfCode = "1369509498032808905";
        List<OrgTreeDto> OrgDTOList=new ArrayList<>();
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        String setNewCode;
        List<PubOrg> orgList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(req.getOrgCode())) {
            setNewCode = req.getOrgCode().replaceAll("0+$", "");
        } else {
            setNewCode = "";
        }
        wrapper.eq(ObjectUtil.isNotEmpty(req.getIsDepartment()), PubOrg::getIsDepartment, req.getIsDepartment());
        wrapper.eq( PubOrg::getStatusFlag, 1);
        wrapper.likeRight(ObjectUtil.isNotEmpty(req.getOrgCode()), PubOrg::getOrgCode, setNewCode);
        orgList = this.list(wrapper);

        // 创建一个 Map 来存储机构 ID 和对应的 DTO 对象
        Map<String, OrgTreeDto> orgDtoMap = new HashMap<>();
        // 创建一个 Map 来存储父类的 parentid 和对应的父类节点
        Map<String, OrgTreeDto> parentDtoMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(req.getOrgCode()) && !req.getOrgCode().equals("330000000000")) {
            LambdaQueryWrapper<PubOrg> wrapper2 = new LambdaQueryWrapper<>();
            if (ObjectUtil.isNotEmpty(req.getOrgCode())) {
                selfCode = req.getOrgCode();
            }
            wrapper2.eq(ObjectUtil.isNotEmpty(req.getOrgCode()), PubOrg::getOrgCode, selfCode);
            PubOrg orgA= this.getOne(wrapper2);
            String id = this.getOne(wrapper2).getOrgId().toString();
            selfCode = id;
            PubOrg org = this.getById(Long.parseLong(id));
            OrgTreeDto orgDTO = new OrgTreeDto();
            BeanPlusUtil.copyProperties(org, orgDTO);
            orgDTO.setName(org.getDName());
            orgDTO.setCode(org.getOrgCode());
            orgDTO.setType(org.getOrgType());
            orgDtoMap.put(org.getOrgId().toString(), orgDTO);
        }

        // 第一轮遍历：创建 OrgTreeDto 对象并将其加入到 Map 中
        for (PubOrg org : orgList) {
            OrgTreeDto orgDTO = new OrgTreeDto();
            BeanPlusUtil.copyProperties(org, orgDTO);
            orgDTO.setName(org.getDName());
            orgDTO.setCode(org.getOrgCode());
            orgDTO.setType(org.getOrgType());
            orgDtoMap.put(org.getOrgId().toString(), orgDTO);

            // 如果 parentid 是传进来的值，则将其作为顶级节点添加到 OrgDTOList 中
            if (org.getOrgId().toString().equals(selfCode)) {
                OrgDTOList.add(orgDTO);
            }
        }

        // 第二轮遍历：将子节点连接到父节点或添加为顶级节点
        boolean isStartAddingChildren = false;
        for (PubOrg org : orgList) {
            String parentId = org.getOrgParentId().toString();
            OrgTreeDto orgDTO = orgDtoMap.get(org.getOrgId().toString());

            // 如果找到传入的ID对应的节点，则开始添加子节点
            if (org.getOrgId().toString().equals(selfCode)) {
                isStartAddingChildren = true;
            }

            // 如果 isStartAddingChildren 为 true，并且 parentDtoMap 中有对应的父类节点，则将节点连接到父节点
            if (isStartAddingChildren && parentDtoMap.containsKey(parentId)) {
                OrgTreeDto parentDto = parentDtoMap.get(parentId);
                parentDto.addChild(orgDTO);
            }

            // 将当前节点添加到 parentDtoMap 中，以便后续节点连接
            parentDtoMap.put(org.getOrgId().toString(), orgDTO);
        }

        return OrgDTOList;
    }

    private LambdaQueryWrapper<PubOrg> createWrapper(QueryOrgReq req) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotEmpty(req.getIsDepartment()), PubOrg::getIsDepartment, req.getIsDepartment());
        //根据业务编码查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLevel()), PubOrg::getLevelFlag, req.getLevel());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), PubOrg::getOrgId,req.getOrgId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getParentId()), PubOrg::getOrgParentId,Long.parseLong(req.getParentId())  );
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgCode()), PubOrg::getOrgCode, req.getOrgCode());


        return wrapper;
    }

}










