package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetBoxReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.exception.enums.CabinetBoxExceptionEnum;
import com.junmp.jyzb.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.mapper.CabinetBoxMapper;
import com.junmp.jyzb.mapper.PoliceFingerMapper;
import com.junmp.jyzb.mapper.PolicemanMapper;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
public class CabinetBoxServiceImpl extends ServiceImpl<CabinetBoxMapper, CabinetBox> implements CabinetBoxService {

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PoliceFingerMapper policeFingerMapper;

    @Resource
    private CabinetService cabinetService;

    @Override
    public List<Map<String, Object>> getAllBoxMsg(String id) {
        return cabinetBoxMapper.getBoxMsg(id);
    }

    /**
         * @author lxh
         * @description 通过cabinetId获取箱门信息列表
         * @since 2023/7/18 22:20
         * @param
         * @return
         **/
    @Override
    public List<CabinetBox> getCabinetBoxList(CabinetReq req) {
        List<CabinetBox> cabinetBoxList = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()),CabinetBox::getCabinetId, req.getId()));
        return cabinetBoxList;
    }

    //添加箱门信息
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean AddBoxInfo(UpdateCabinetBoxReq req) {
        CabinetBox one = cabinetBoxService.getOne(new LambdaQueryWrapper<CabinetBox>()
                .eq(CabinetBox::getId, req.getId()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(CabinetBoxExceptionEnum.CABINETBOX_IS_EXISTS);
        }
        CabinetBox cabinetBox = new CabinetBox();
        BeanPlusUtil.copyProperties(req,cabinetBox);
        //添加单警柜箱门信息默认状态为1
        cabinetBox.setState(1);
        Cabinet cabinet = cabinetService.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(Cabinet::getCabinetNum, req.getCabinetNum()));
        if (ObjectUtil.isNull(cabinet)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        cabinetBox.setCabinetId(cabinet.getId());
        Integer num = cabinet.getNum();
        if (num==null){
            num=1;
            cabinet.setNum(num);
        }else {
            cabinet.setNum(cabinet.getNum()+1);
        }
        cabinetService.updateById(cabinet);
        return save(cabinetBox);
    }

}
