package com.junmp.jyzb.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum PubOrgExceptionEnum implements IExceptionEnum {
    /**
     * 组织机构不存在
     */
    PUBORG_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"组织机构不存在"),
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PubOrgExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
