package com.junmp.jyzb.doc;

import com.junmp.jyzb.api.bean.query.ProductReq;
import com.junmp.jyzb.entity.Product;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 16:25
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Api(value = "产品管理", tags = "产品管理接口")
public interface ProductDoc {

    /**
     * 新增产品
     */
    @ApiOperation(value = "新增产品", tags = "产品管理接口")
    ApiRes<Boolean> addProduct(ProductReq req);

    /**
     * 更新产品
     */
    @ApiOperation(value = "更新产品", tags = "产品管理接口")
    ApiRes<Boolean> editProduct(ProductReq req);


    /**
     * 获取所有产品
     */
    @ApiOperation(value = "获取所有产品", tags = "产品管理接口")
    ApiRes<List<Product>> list(ProductReq req);

    /**
     * 删除产品
     */
    @ApiOperation(value = "删除产品",tags = "产品管理接口")
    ApiRes<Boolean> delProduct(ProductReq req);


    /**
     * 分页产品信息
     */
    @ApiOperation(value = "分页产品信息", tags = "产品管理接口")
    ApiRes<PageResult<Product>> page(ProductReq req);
}
